<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin_m extends CI_Model {
    
	public function fetch_guard_hr_attendence()
	{
		$this->db->select('attendence.*, guard_location.l_id, guard_location.LAT as lat, guard_location.LONGI long, guard_location.area,  
		                    guard_location.office_id, mst_guard.name ,mst_guard.id gurardid');
	 	$this->db->where('attendence.deleted_DT',NULL);
		$this->db->from('attendence');
		$this->db->join('guard_location','guard_location.attendance_id=attendence.a_id','left');
		$this->db->join('mst_guard','mst_guard.id=attendence.guard_id','left');
		$this->db->order_by("attendence.a_id","desc");
		$locations = $this->db->get()->result();
		
		$data['offices'] = array();
		$offices = $this->db->where('Deleted_DT IS NULL')->get('mst_office')->result();
		if(!empty($offices)) {
		    foreach($offices as $office) {
		        $data['offices'][$office->id] = $office; 
		    }
		}
		
		
		$data['guardlocations'] = array();
		if(!empty($locations)) {
		    foreach($locations as $loc) {
		        $data['guardlocations'][$loc->a_id]['location'][$loc->l_id] = $loc;
		        if(!empty($data['offices']) && in_array($loc->office_id, array_keys($data['offices']))) {
		            
		            $incircleStatus = $this->check_inside_circle( $data['offices'][$loc->office_id]->Latitude, $data['offices'][$loc->office_id]->Longitude, $loc->lat, $loc->long) ; 
		            if(!empty($incircleStatus) && $incircleStatus == 'Out Circle') {
	                    $data['guardlocations'][$loc->a_id]['status'][$loc->l_id] = '<span style="font-weight: bold; color: red">Out Circle</span>';
		                $data['guardlocations'][$loc->a_id]['office_id'] = $loc->office_id;   
		                
		                
		                
            		        $data['guardlocations'][$loc->a_id]['gurardid'] = $loc->gurardid; 
            		        $data['guardlocations'][$loc->a_id]['date'] = !empty($loc->PI_DT) ? date('Y-m-d H:i:s', strtotime($loc->PI_DT)) : ''; 
            		        $data['guardlocations'][$loc->a_id]['name'] = $loc->name; 
            		        
		                
		            }
		            
		             
		        }
		        
		    }
		}		
		

// echo '<pre>';
// print_R($data['guardlocations']);exit;

        return $data;
	}
	
	
    public function check_inside_circle( $center_lat, $center_lng, $lat2, $long2) {
        if($this->checkFloat($center_lat) && $this->checkFloat($center_lng) && $this->checkFloat($lat2) && $this->checkFloat($long2)) {
    	    $distance =  ( 6371 * acos( cos( deg2rad($center_lat) ) * cos( deg2rad( $lat2 ) ) * cos( deg2rad( $long2 ) 
    	                - deg2rad($center_lng) ) + sin( deg2rad($center_lat) ) * sin( deg2rad( $lat2 ) ) ) );
            if(((int)($distance * 1000)) < RADIUS) {
                return 'In Circle';
                // return  $center_lat .'||'. $center_lng .'||'.$lat2 .'||'.$long2 .  '<span style="font-weight: bold; color: green">In Circle</span>' . $distance * 1000;
    			 
            } else {
                return 'Out Circle';
    // 			return    $center_lat .'||'. $center_lng .'||'.$lat2 .'||'.$long2 . '<span style="font-weight: bold; color: red">Out Circle</span>' . $distance * 1000;
            }
        } else {
            return '';
        }

	}
    
    	
	public function checkFloat($num) {
	    // Try to convert the string to a float
        $floatVal = floatval($num);
        // If the parsing succeeded and the value is not equivalent to an int
        if($floatVal && intval($floatVal) != $floatVal)
        {
            return true;
        } else {
            return false;
        }
	}
    
	public function standardinsert(){
		$data=array("Uniq_Id"=>$_POST['stdid'],
					"Std_Initial"=>$_POST['std_initial'],
					"Standard"=>$_POST['standard'],
					"Inserted_SI"=>$this->session->userdata('userid'),
					"Inserted_BY"=>$this->session->userdata('name'),
					"Inserted_DT"=>date('Y-m-d H:s:i'));
		$this->db->insert('standard_t',$data);
	}
	public function standardupdate($id){
		$data=array("Std_Initial"=>$_POST['std_initial'],
					"Standard"=>$_POST['standard'],
					"Modified_SI"=>$this->session->userdata('userid'),
					"Modified_BY"=>$this->session->userdata('name'),
					"Modified_DT"=>date('Y-m-d H:s:i'));
		$this->db->where('Uniq_Id',$id)->update('standard_t',$data);
	}
	public function subjectinsert(){
		$data=array("Standard_Id"=>$_POST['standard_name'],
					"Subject"=>$_POST['subject'],
					"Inserted_SI"=>$this->session->userdata('userid'),
					"Inserted_BY"=>$this->session->userdata('name'),
					"Inserted_DT"=>date('Y-m-d H:s:i'));
		$this->db->insert('subject_t',$data);
	}
	public function subjectupdate($id){
		$data=array("Standard_Id"=>$_POST['standard_name'],
					"Subject"=>$_POST['subject'],
					"Modified_SI"=>$this->session->userdata('userid'),
					"Modified_BY"=>$this->session->userdata('name'),
					"Modified_DT"=>date('Y-m-d H:s:i'));
		$this->db->where('Subject_Id',$id)->update('subject_t',$data);
	}
	public function topicinsert(){
		$data=array("Standard_Id"=>$_POST['standard_name'],
					"Subject_Id"=>$_POST['subject_name'],
					"Topic"=>$_POST['topic'],
					"Description"=>$_POST['topic_desc'],
					"Inserted_SI"=>$this->session->userdata('userid'),
					"Inserted_BY"=>$this->session->userdata('name'),
					"Inserted_DT"=>date('Y-m-d H:s:i'));
		$this->db->insert('topic_t',$data);
	}
	public function topicupdate($id){
		$data=array("Standard_Id"=>$_POST['standard_name'],
					"Subject_Id"=>$_POST['subject_name'],
					"Topic"=>$_POST['topic'],
					"Description"=>$_POST['topic_desc'],
					"Modified_SI"=>$this->session->userdata('userid'),
					"Modified_BY"=>$this->session->userdata('name'),
					"Modified_DT"=>date('Y-m-d H:s:i'));
		$this->db->where('Topic_Id',$id)->update('topic_t',$data);
	}
	public function branchinsert(){
		$data=array("Uniq_Id"=>$_POST['banchid'],
					"Branch_Name"=>$_POST['branch_initial'],
					"Branch_Initial"=>$_POST['branch'],
					"Inserted_SI"=>$this->session->userdata('userid'),
					"Inserted_BY"=>$this->session->userdata('name'),
					"Inserted_DT"=>date('Y-m-d H:s:i'));
		$this->db->insert('branch_t',$data);
	}
	public function branchupdate($id){
		$data=array("Branch_Name"=>$_POST['branch_initial'],
					"Branch_Initial"=>$_POST['branch'],
					"Modified_SI"=>$this->session->userdata('userid'),
					"Modified_BY"=>$this->session->userdata('name'),
					"Modified_DT"=>date('Y-m-d H:s:i'));
		$this->db->where('Uniq_Id',$id)->update('branch_t',$data);
	}
	public function admininsert(){
		$data=array("User_Type"=>1,
					"First_Name"=>$_POST['fname'],
					"Last_Name"=>$_POST['lname'],
					"Email_Id"=>$_POST['emailid'],
					"Mobile_No"=>$_POST['contact'],
					"Username"=>$_POST['username'],
					"Password"=>$_POST['password'],
					"Inserted_SI"=>$this->session->userdata('userid'),
					"Inserted_BY"=>$this->session->userdata('name'),
					"Inserted_DT"=>date('Y-m-d H:s:i'));
		$this->db->insert('login_t',$data);
	}
	public function adminupdate($id){
		$data=array("First_Name"=>$_POST['fname'],
					"Last_Name"=>$_POST['lname'],
					"Email_Id"=>$_POST['emailid'],
					"Mobile_No"=>$_POST['contact'],
					"Username"=>$_POST['username'],
					"Password"=>$_POST['password'],
					"Modified_SI"=>$this->session->userdata('userid'),
					"Modified_BY"=>$this->session->userdata('name'),
					"Modified_DT"=>date('Y-m-d H:s:i'));
		$this->db->where('Login_Id',$id)->update('login_t',$data);
	}
	public function studentinsert(){
		$data=array("User_Type"=>2,
					"First_Name"=>$_POST['fname'],
					"Last_Name"=>$_POST['lname'],
					"Email_Id"=>$_POST['emailid'],
					"Mobile_No"=>$_POST['contact'],
					"Branch"=>$_POST['branch_name'],
					"Standard"=>$_POST['standard_name'],
					"Username"=>$_POST['username'],
					"Password"=>$_POST['password'],
					"Inserted_SI"=>$this->session->userdata('userid'),
					"Inserted_BY"=>$this->session->userdata('name'),
					"Inserted_DT"=>date('Y-m-d H:s:i'));
		$this->db->insert('login_t',$data);
	}
	public function excelstudentinsert()
	{
		 if(isset($_POST['LCLRow'])) {
        foreach($_POST['LCLRow'] as $key=>$rs)
        {    
		    $query=$this->db->order_by('Login_Id', 'DESC')->limit('1')->get('login_t')->row();
				
				$pqidlength = strlen($query->Login_Id);
				if($pqidlength == 1)
				{
					$uniqidd = '000'.$query->Login_Id+1;
				}
				else if($pqidlength == 2)
				{
					$uniqidd = '00'.$query->Login_Id+1;
				}
				else if($pqidlength == 3)
				{
					$uniqidd = '0'.$query->Login_Id+1;
				}
				else
				{
					$uniqidd = $query->Login_Id+1;
				}
			$data=array(
			        "User_Type"=>2,
			        "First_Name"=>$rs[0],
					"Last_Name"=>$rs[1],
					"Email_Id"=>$rs[2],
					"Mobile_No"=>$rs[3],
					"Branch"=>$_POST['branch'],
					"Standard"=>$_POST['std'],
					"Username"=>$_POST['branch'].$_POST['std'].$uniqidd,
					"Password"=>$_POST['branch'].$_POST['std'].$uniqidd,
					"Inserted_SI"=>$this->session->userdata('userid'),
                    "Inserted_BY"=>$this->session->userdata('name'),
                    "inserted_DT"=>date('Y-m-d H:i:s'));
           $this->db->insert('login_t',$data);
		}
        
        }
	}
	public function pps_insert()
	{
		$data=array(
		            "Test_Title"=>$_POST['testtitle'],
					"Branch"=>$_POST['branch'],
					"STD"=>$_POST['std'],
					"Subject"=>$_POST['subject'],
					"Topic"=>$_POST['topic'],
					"Test_Start_DT"=>$_POST['teststartdt'],
					"Test_END_DT"=>$_POST['testenddt'],
					"Test_Time"=>$_POST['testtime'],
					"Inserted_SI"=>$this->session->userdata('userid'),
					"Inserted_BY"=>$this->session->userdata('name'),
					"Inserted_DT"=>date('Y-m-d H:s:i'));
		$this->db->insert('pps',$data);
	}
	public function pps_update($ppsid)
	{
		$data=array(
		            "Test_Title"=>$_POST['testtitle'],
					"Branch"=>$_POST['branch'],
					"STD"=>$_POST['std'],
					"Subject"=>$_POST['subject'],
					"Topic"=>$_POST['topic'],
					"Test_Start_DT"=>$_POST['teststartdt'],
					"Test_END_DT"=>$_POST['testenddt'],
					"Test_Time"=>$_POST['testtime'],
					"Inserted_SI"=>$this->session->userdata('userid'),
					"Inserted_BY"=>$this->session->userdata('name'),
					"Inserted_DT"=>date('Y-m-d H:s:i'));
		$this->db->where('PPS_ID',$ppsid);			
		$this->db->update('pps',$data);
	}

	  public function insertemployee(){
         $file = 'employee.txt';
		$uniq = file_get_contents($file);
	    $id = $uniq + 01 ;
		file_put_contents($file, $id);
    	$emp_Id =  "E000".$id;
       $data=array("emp_id"=>$emp_Id,
            	   "usertyp"=>$_POST['desc'],
            		"fname"=>$_POST['fname'],
            		"mname"=>$_POST['mname'],
            	   "lname"=>$_POST['lname'],
            		"address"=>$_POST['address'],
            		"emailid"=>$_POST['emailid'],
            		"mobileno"=>$_POST['mobile'],
            	
            		"designation"=>$_POST['desc'],
            		"username"=>$_POST['username'],
            		"password"=>$_POST['password'],
            		"Inserted_SI"=>$this->session->userdata('id'),
                    "Inserted_BY"=>$this->session->userdata('username'),
                    "Inserted_DT"=>date('Y-m-d H:i:s'));
        $c=$this->db->insert('login_t',$data);
    }
    public function updateemployee($id){
         
       $data=array("usertyp"=>$_POST['desc'],
            		"fname"=>$_POST['fname'],
            		"mname"=>$_POST['mname'],
            	   "lname"=>$_POST['lname'],
            		"address"=>$_POST['address'],
            		"emailid"=>$_POST['emailid'],
            		"mobileno"=>$_POST['mobile'],
            		
            		"designation"=>$_POST['desc'],
            		//"username"=>$_POST['username'],
            		"password"=>$_POST['password'],
            		"Modified_SI"=>$this->session->userdata('id'),
                    "Modified_BY"=>$this->session->userdata('username'),
                    "Modified_DT"=>date('Y-m-d H:i:s'));
        $c=$this->db->where('emp_id',$id)->update('login_t',$data);
    }
     public function insertuserright(){
        
        if(isset($_POST['LCLRow'])){
          //  $check_0 = isset($_POST['LCLRow'][0]) ? 1 : 0;
           // print_r($_POST['LCLRow']);
                    foreach($_POST['LCLRow'] as $rs)
            		{
            		    //$rs0 = isset($rs[1]) ? 1 : 0;
                       $check_1 = isset($rs[1]) ? 1 : 0;
                        $check_2 = isset($rs[2]) ? 2 : 0;
                        $check_3 = isset($rs[3]) ? 3 : 0;
                        $check_4 = isset($rs[4]) ? 4 : 0;
            			$data=array("User_Id"=>$_POST['user'],
            			            "Form_Name"=>$rs[0],
            			            "Form_Save"=>$check_1,
            			            "Form_Update"=>$check_2,
            			            "Form_View"=>$check_3,
            			            "Form_Delete"=>$check_4,
            						"Inserted_SI"=>$this->session->userdata('id'),
                                    "Inserted_BY"=>$this->session->userdata('username'),
                                    "Inserted_DT"=>date('Y-m-d H:i:s'));
                        $c=$this->db->insert('userright_t',$data);
            	    }}
    }
    public function updateuserright($user){
        
        if(isset($_POST['LCLRow'])){
          //  $check_0 = isset($_POST['LCLRow'][0]) ? 1 : 0;
            
                    foreach($_POST['LCLRow'] as $rs)
            		{
            		    //$rs0 = isset($rs[1]) ? 1 : 0;
                       $check_1 = isset($rs[1]) ? 1 : 0;
                        $check_2 = isset($rs[2]) ? 2 : 0;
                        $check_3 = isset($rs[3]) ? 3 : 0;
                        $check_4 = isset($rs[4]) ? 4 : 0;
            			$data=array("Form_Name"=>$rs[0],
            			            "Form_Save"=>$check_1,
            			            "Form_Update"=>$check_2,
            			            "Form_View"=>$check_3,
            			            "Form_Delete"=>$check_4,
            						"Modified_SI"=>$this->session->userdata('id'),
                                    "Modified_BY"=>$this->session->userdata('username'),
                                    "Modified_DT"=>date('Y-m-d H:i:s'));
                        $c=$this->db->where('Userright_Id',$rs[5])->update('userright_t',$data);
            	    }
            if(empty($rs[5])){
                $data=array("User_Id"=>$user,
            			            "Form_Name"=>$rs[0],
            			            "Form_Save"=>$check_1,
            			            "Form_Update"=>$check_2,
            			            "Form_View"=>$check_3,
            			            "Form_Delete"=>$check_4,
            						"Inserted_SI"=>$this->session->userdata('id'),
                                    "Inserted_BY"=>$this->session->userdata('username'),
                                    "Inserted_DT"=>date('Y-m-d H:i:s'));
                        $c=$this->db->insert('userright_t',$data);
            }
        }
    }
}
