<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin extends CI_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model("Quarantine_Model");
		$this->load->model("Guard_Model");
		$this->load->model("Designation_Model");
		$this->load->model("Duty_Model");
		$this->load->model("Announcement_Model");
		$this->load->model("Complaint_Model");
		$this->load->model("Hospital_model");
		$this->load->model("Risk_Model");
		$this->load->model("Admin_m");
		$this->load->library("Custom");
		$this->load->helper(array('form', 'url'));
		
        date_default_timezone_set('Asia/Kolkata');
		if(empty($this->session->userdata("name")))
        {
           redirect("Login");
        }
        
	}

    public function map_view($locid) {
        if(!empty($locid)) {
            $location = $this->db->where('deleted_DT IS NULL')->where('l_id', $locid)->get('guard_location')->row();
            $patient =  $this->db->where('deleted_DT IS NULL')->where('id', $location->guard_id)->get('mst_guard')->row();
            $q_location = $this->db->where('deleted_DT IS NULL')->where('id', $location->office_id)->get('mst_office')->row();
            $data['q_lat'] = $q_location->Latitude;
            $data['q_long'] = $q_location->Longitude;
            $data['p_lat'] = $location->LAT;
            $data['p_long'] = $location->LONGI;
            $data['p_address'] = $patient->address;
            $data['p_name'] = $patient->name;
            $data['q_address'] = $q_location->address;
            $data['q_name'] = $q_location->name;
            
            $this->load->view('admin/map_view', $data);
        }

    }

	public function index()
	{
	     $guardcount = $this->db->get('mst_guard')->num_rows();
	     $guardActivecount = $this->db->where('deleted_DT',NULL)->get('mst_guard')->num_rows();
	     $guardNonActivecount = $this->db->where('deleted_DT IS NOT NULL')->get('mst_guard')->num_rows();
	     $announcmentCount = $this->db->where('announcement.deleted_DT',NULL)
	                            ->from('announcement')->join('mst_office','mst_office.id=announcement.a_office','left')
	                            ->get()->num_rows();
	     
	     
	     $mst_quarantine = $this->db->where('deleted_DT',NULL)->get('mst_office')->num_rows();
	     $emp_count = $this->db->where('Deleted_DT',NULL)->get('login_t')->num_rows();
	   //  $guardstatus = $this->db->where('deleted_DT',NULL)->where('status','active')->get('mst_guard')->num_rows();
	     
	        if($guardcount>=0) {
                $gcount = $guardcount;
            }  else {
                 $gcount=0;
            }
             
            if($mst_quarantine>=0) {
                $g_scount = $mst_quarantine;
            } else {
                 $g_scount=0;
            }
            
            if(empty($emp_count)) {
                $emp_count = 0;
            }
             
            //get inform count array
            $informed = $this->db->select('COUNT(l_id) inf_count, guard_id ')->where('deleted_DT IS NULL')
                                    ->where('inform_status', 1)->group_by('guard_id')->get('guard_location')->result();
            if(!empty($informed)) {
                foreach($informed as $inf) {
                    $data['informed'][$inf->guard_id] = $inf->inf_count;
                }
            }
            
            
            $data['offices'] = array();
            $offices = $this->db->where('Deleted_DT IS NULL')->get('mst_office')->result();
            if(!empty($offices)) {
                foreach($offices as $office) {
                    $data['offices'][$office->id] = $office; 
                }
            }
            
            $data['guard'] = array();
            $guards = $this->db->where('Deleted_DT IS NULL')->get('mst_guard')->result();
            if(!empty($guards)) {
                foreach($guards as $guard) {
                    $data['guard'][$guard->id]['name'] = $guard->name; 
                    $data['guard'][$guard->id]['contact'] = $guard->contact; 
                }
            }
            
            
            $location_arr = $this->db->where('deleted_DT IS NULL')->where("DATE(datetime) = CURDATE()")->order_by('l_id', 'DESC')->get('guard_location')->result();
            $data['location_arr'] = array();
            if(!empty($location_arr)) {
                foreach($location_arr as $location) {
                    if(!empty($data['guard'][$location->guard_id])) { //deactive or deleted user location filter
                    
                        
                        $officeLong =  !empty($data['offices'][$location->office_id]->Longitude) ? $data['offices'][$location->office_id]->Longitude : '';
                        $officeLat =  !empty($data['offices'][$location->office_id]->Latitude) ? $data['offices'][$location->office_id]->Latitude : '';
                        
                        $circle_status = '';
                        if(!empty($officeLong) && !empty($officeLat)) {
                            $circle_status = $this->check_inside_circle($officeLat, $officeLong, $location->LAT, $location->LONGI);     
                        } 
                    
                        // if(empty in result, OR (outcircle AND date is greater than existing date)  )
                        if((empty($data['location_arr'][$location->guard_id]) && $circle_status == 'Out Circle') || 
                        
                        ( !empty($data['location_arr'][$location->guard_id]) && $data['location_arr'][$location->guard_id]['status'] == 'Out Circle' && 
                            strtotime($data['location_arr'][$location->guard_id]['date']) <= strtotime($location->datetime)
                            )) {
                            
                                $data['location_arr'][$location->guard_id]['location'] = $location; 
                                $data['location_arr'][$location->guard_id]['date'] = $location->datetime; 
                                $data['location_arr'][$location->guard_id]['inform_status'] = $location->inform_status;
                                $data['location_arr'][$location->guard_id]['inform_count'] = !empty($data['informed'][$location->guard_id]) ? $data['informed'][$location->guard_id] : 0; 
                                
                                $data['location_arr'][$location->guard_id]['office_name'] = !empty($data['offices'][$location->office_id]->name) ? $data['offices'][$location->office_id]->name : ''; 
                                $data['location_arr'][$location->guard_id]['office_city'] = !empty($data['offices'][$location->office_id]->city) ? $data['offices'][$location->office_id]->city : ''; 
                                $data['location_arr'][$location->guard_id]['office_address'] = !empty($data['offices'][$location->office_id]->address) ? $data['offices'][$location->office_id]->address : ''; 
                                $data['location_arr'][$location->guard_id]['guard_contact'] = !empty($data['guard'][$location->guard_id]['contact']) ? $data['guard'][$location->guard_id]['contact'] : ''; 
                                $data['location_arr'][$location->guard_id]['guard'] = !empty($data['guard'][$location->guard_id]['name']) ? $data['guard'][$location->guard_id]['name'] : ''; 
                                
                                // $officeLong =  !empty($data['offices'][$location->office_id]->Longitude) ? $data['offices'][$location->office_id]->Longitude : '';
                                // $officeLat =  !empty($data['offices'][$location->office_id]->Latitude) ? $data['offices'][$location->office_id]->Latitude : '';
                                
                                
                                $data['location_arr'][$location->guard_id]['status'] = $circle_status;
                                
                                
                        }
                    }
                }
            }
             
// echo '<pre>';
// print_R($data['location_arr']);exit;
             
             $data1 = array( 
                           "count_guard"=>$gcount,
                           "count_guard_nonactive"=>$guardNonActivecount,
                           "count_guard_active"=>$guardActivecount,
                           "quorantine_location"=>$g_scount,
                           "employee_count"=>$emp_count,
                           "announcement_count"=>$announcmentCount,
                           "location_arr" => $data['location_arr'],
                         );
                         

 
		$this->load->view('admin/dashboard',$data1);
	}


    public function inform_outcircle() {
        if(!empty($_POST['location_id'])) {
            $data['inform_status'] = 1;
            $data['inform_SI'] = $this->session->userdata('id');
            $data['inform_DT'] = date('Y-m-d H:s:i');
            $this->db->where('deleted_DT IS NULL')->where('l_id', $_POST['location_id'])->update('guard_location', $data);  
            $this->session->set_flashdata(array('info_success'=> 1));
        }
        redirect('Admin');
    }


	public function index_old()
	{
	     $guardcount = $this->db->where('deleted_DT',NULL)->get('mst_guard')->num_rows();
	     $mst_quarantine = $this->db->where('deleted_DT',NULL)->get('mst_office')->num_rows();
	     $emp_count = $this->db->where('Deleted_DT',NULL)->get('login_t')->num_rows();
	   //  $guardstatus = $this->db->where('deleted_DT',NULL)->where('status','active')->get('mst_guard')->num_rows();
	     
	        if($guardcount>=0) {
                $gcount = $guardcount;
            }  else {
                 $gcount=0;
            }
             
            if($mst_quarantine>=0) {
                $g_scount = $mst_quarantine;
            } else {
                 $g_scount=0;
            }
            
            if(empty($emp_count)) {
                $emp_count = 0;
            }
             
            
            
            $data['offices'] = array();
            $offices = $this->db->where('Deleted_DT IS NULL')->get('mst_office')->result();
            if(!empty($offices)) {
                foreach($offices as $office) {
                    $data['offices'][$office->id] = $office; 
                }
            }
            
            $data['guard'] = array();
            $guards = $this->db->where('Deleted_DT IS NULL')->get('mst_guard')->result();
            if(!empty($guards)) {
                foreach($guards as $guard) {
                    $data['guard'][$guard->id]['name'] = $guard->name; 
                    $data['guard'][$guard->id]['contact'] = $guard->contact; 
                }
            }
            
            
            $location_arr = $this->db->where('deleted_DT IS NULL')->where("DATE(datetime) = CURDATE()")->order_by('l_id', 'DESC')->get('guard_location')->result();
            $data['location_arr'] = array();
            if(!empty($location_arr)) {
                foreach($location_arr as $location) {
                    if(!empty($data['guard'][$location->guard_id])) { //deactive or deleted user location filter
                        $data['location_arr'][$location->l_id]['location'] = $location; 
                        // $data['location_arr'][$location->l_id]['city'] = $location->city; 
                        $data['location_arr'][$location->l_id]['office_name'] = !empty($data['offices'][$location->office_id]->name) ? $data['offices'][$location->office_id]->name : ''; 
                        $data['location_arr'][$location->l_id]['office_city'] = !empty($data['offices'][$location->office_id]->city) ? $data['offices'][$location->office_id]->city : ''; 
                        $data['location_arr'][$location->l_id]['office_address'] = !empty($data['offices'][$location->office_id]->address) ? $data['offices'][$location->office_id]->address : ''; 
                        $data['location_arr'][$location->l_id]['guard_contact'] = !empty($data['guard'][$location->guard_id]['contact']) ? $data['guard'][$location->guard_id]['contact'] : ''; 
                        $data['location_arr'][$location->l_id]['guard'] = !empty($data['guard'][$location->guard_id]['name']) ? $data['guard'][$location->guard_id]['name'] : ''; 
                        
                        $officeLong =  !empty($data['offices'][$location->office_id]->Longitude) ? $data['offices'][$location->office_id]->Longitude : '';
                        $officeLat =  !empty($data['offices'][$location->office_id]->Latitude) ? $data['offices'][$location->office_id]->Latitude : '';
                        
                        if(!empty($officeLong) && !empty($officeLat)) {
            // var_dump($this->check_inside_circle($officeLat, $officeLong, $location->LAT, $location->LONGI));exit;
                            $data['location_arr'][$location->l_id]['status'] = $this->check_inside_circle($officeLat, $officeLong, $location->LAT, $location->LONGI);     
                        } else {
                            $data['location_arr'][$location->l_id]['status'] = ''; 
                        }
                    }
                }
            }
             
             
             
             $data1 = array( 
                           "count_guard"=>$gcount,
                           "quorantine_location"=>$g_scount,
                           "employee_count"=>$emp_count,
                           "location_arr" => $data['location_arr'],
                         );
                         

 
		$this->load->view('admin/dashboard',$data1);
	}



    public function patient_history() {
        $patientid = $_POST['guardid'];
        
                    
        $data['offices'] = array();
        $offices = $this->db->where('Deleted_DT IS NULL')->get('mst_office')->result();
        if(!empty($offices)) {
            foreach($offices as $office) {
                $data['offices'][$office->id] = $office; 
            }
        }
        
        $data['guard'] = array();
        $guards = $this->db->where('Deleted_DT IS NULL')->where('id', $patientid)->get('mst_guard')->result();
        if(!empty($guards)) {
            foreach($guards as $guard) {
                $data['guard'][$guard->id]['name'] = $guard->name; 
                $data['guard'][$guard->id]['contact'] = $guard->contact; 
            }
        }
            if(!empty($_POST['gdate'])) {
                $this->db->where("date(datetime) = '{$_POST['gdate']}'");
            } else {
                $this->db->where("DATE(datetime) = CURDATE()");   
            }
            
            $location_arr = $this->db->where('deleted_DT IS NULL')->get('guard_location')->result();

            $data['location_arr'] = array();
            if(!empty($location_arr)) {
                foreach($location_arr as $location) {
                    if(!empty($data['guard'][$location->guard_id])) { //deactive or deleted user location filter
                    
                        
                        $officeLong =  !empty($data['offices'][$location->office_id]->Longitude) ? $data['offices'][$location->office_id]->Longitude : '';
                        $officeLat =  !empty($data['offices'][$location->office_id]->Latitude) ? $data['offices'][$location->office_id]->Latitude : '';
                        
                        $circle_status = '';
                        if(!empty($officeLong) && !empty($officeLat)) {
                            $circle_status = $this->check_inside_circle($officeLat, $officeLong, $location->LAT, $location->LONGI);     
                        } 
                    
                        if($circle_status == 'Out Circle') {
                            
                                // $data['location_arr'][$location->l_id]['location'] = $location; 
                                $data['location_arr'][$location->l_id]['date'] = $location->datetime; 
                                $data['location_arr'][$location->l_id]['date_formated'] = date('Y-m-d', strtotime($location->datetime)); 
                                $data['location_arr'][$location->l_id]['guardid'] = $location->guard_id; 
                                
                                $data['location_arr'][$location->l_id]['office_name'] = !empty($data['offices'][$location->office_id]->name) ? $data['offices'][$location->office_id]->name : ''; 
                                $data['location_arr'][$location->l_id]['office_city'] = !empty($data['offices'][$location->office_id]->city) ? $data['offices'][$location->office_id]->city : ''; 
                                $data['location_arr'][$location->l_id]['office_address'] = !empty($data['offices'][$location->office_id]->address) ? $data['offices'][$location->office_id]->address : ''; 
                                $data['location_arr'][$location->l_id]['guard_contact'] = !empty($data['guard'][$location->guard_id]['contact']) ? $data['guard'][$location->guard_id]['contact'] : ''; 
                                $data['location_arr'][$location->l_id]['guard'] = !empty($data['guard'][$location->guard_id]['name']) ? $data['guard'][$location->guard_id]['name'] : ''; 
                                
                                $data['location_arr'][$location->l_id]['status'] = $circle_status;
                                
                                
                        }
                    }
                }
            }
             
            echo json_encode($data['location_arr']);exit;
           

        
    }

	  public function check_inside_circle( $center_lat, $center_lng, $lat2, $long2) {

        if($this->checkFloat($center_lat) && $this->checkFloat($center_lng) && $this->checkFloat($lat2) && $this->checkFloat($long2)) {
    	    $distance =  ( 6371 * acos( cos( deg2rad($center_lat) ) * cos( deg2rad( $lat2 ) ) * cos( deg2rad( $long2 ) 
    	                - deg2rad($center_lng) ) + sin( deg2rad($center_lat) ) * sin( deg2rad( $lat2 ) ) ) );
            if(((int)($distance * 1000)) < RADIUS) {
                return 'In Circle';
                // return 'In Circle | '. $distance;
                // return  $center_lat .'||'. $center_lng .'||'.$lat2 .'||'.$long2 .  '<span style="font-weight: bold; color: green">In Circle</span>' . $distance * 1000;
    			 
            } else {
                return 'Out Circle';
                // return 'Out Circle | '. $distance;
    // 			return    $center_lat .'||'. $center_lng .'||'.$lat2 .'||'.$long2 . '<span style="font-weight: bold; color: red">Out Circle</span>' . $distance * 1000;
            }
        } else {
            return '';
        }

	}
	
	public function checkFloat($num) {
	    // Try to convert the string to a float
        $floatVal = floatval($num);
        // If the parsing succeeded and the value is not equivalent to an int
        if($floatVal && intval($floatVal) != $floatVal)
        {
            return true;
        } else {
            return false;
        }
	}


	//============================Deactivate Patient =======================//
	public function deactivate_patient() {
	   // select * from mst_guard where DOB < DATE_SUB(NOW(), INTERVAL 14 DAY) ORDER BY `mst_guard`.`DOB` DESC 
	    $guards = $this->db->where('deleted_DT IS NULL')->where(' DOB < DATE_SUB(NOW(), INTERVAL 14 DAY)')->get('mst_guard')->result();
	    if(!empty($guards)) {
	        $set_data['deactive_cronjob_flag'] = 1; 
	        $set_data['deleted_DT'] = date('Y-m-d H:i:s'); 
	        $this->db->where('deleted_DT IS NULL')->where('DOB < DATE_SUB(NOW(), INTERVAL 14 DAY)')->update('mst_guard', $set_data);
// echo $this->db->last_query();
	    }
	    
    //   echo count($guards);exit;  
	}	

		//========================Employee============================//
	public function employee()
	{
	    $data['emp_arr']=$this->db->where('Deleted_DT',NULL)->order_by('login_id','DESC')->get('login_t')->result();
		$this->load->view('admin/employee_grid',$data);
	}
	public function newemployee()
	{
	    $this->load->view('admin/employee');
	}
	public function addemployee_insert()
	{
	    $this->load->library('form_validation');
        
		$this->form_validation->set_rules('fname', 'First Name', 'required|alpha');
		$this->form_validation->set_rules('mname', 'Middle Name', 'alpha');
		$this->form_validation->set_rules('lname', 'Last Name', 'required|alpha');
		$this->form_validation->set_rules('address', 'Address', 'required');
		$this->form_validation->set_rules('emailid', 'Email Id', 'valid_email');
		$this->form_validation->set_rules('mobile', 'Mobile Number', 'numeric|required|min_length[10]',array('min_length'=>"The %s should be 10 characters in length"));
		
		$this->form_validation->set_rules('desc', 'Designation', 'required');
		$this->form_validation->set_rules('username', 'Username', 'required|is_unique[login_t.username]');
		
		$this->form_validation->set_rules('password', 'Password', 'required|min_length[8]');
        if ($this->form_validation->run() == FALSE)
        {
		 	$this->load->view('admin/employee');
        }
        else
        {
            $this->Admin_m->insertemployee();
			$this->session->set_flashdata(array("success"=>1));
			redirect('Admin/employee');
        }
	}
	public function editemployee($id)
	{
	    $data['emp_arr']=$this->db->where('Deleted_DT',NULL)->where('emp_id',$id)->get('login_t')->row();
		$this->load->view('admin/employee',$data);
	}
	public function employee_update($id)
	{
	    $this->load->library('form_validation');
        
	$this->form_validation->set_rules('fname', 'First Name', 'required|alpha');
		$this->form_validation->set_rules('mname', 'Middle Name', 'alpha');
		$this->form_validation->set_rules('lname', 'Last Name', 'required|alpha');
		$this->form_validation->set_rules('address', 'Address', 'required');
		$this->form_validation->set_rules('emailid', 'Email Id', 'valid_email');
			$this->form_validation->set_rules('mobile', 'Mobile Number', 'numeric|required|min_length[10]',array('min_length'=>"The %s should be 10 characters in length"));
		
		$this->form_validation->set_rules('desc', 'Designation', 'required');
	//	$this->form_validation->set_rules('username', 'Username', 'required|is_unique[login_t.username]');
		$this->form_validation->set_rules('password', 'Password', 'required|min_length[8]');
        if ($this->form_validation->run() == FALSE)
        {
		 	$data['emp_arr']=$this->db->where('Deleted_DT',NULL)->where('emp_id',$id)->get('login_t')->row();
		    $this->load->view('admin/employee',$data);
        }
        else
        {
            $this->Admin_m->updateemployee($id);
			$this->session->set_flashdata(array("usuccess"=>1));
			redirect('Admin/employee');
        }
	}
		public function employee_delete($id){
	    $data=array("Deleted_SI"=>$this->session->userdata('id'),
                                    "Deleted_BY"=>$this->session->userdata('username'),
                                    "Deleted_DT"=>date('Y-m-d H:i:s'));
        $c=$this->db->where('emp_id',$id)->update('login_t',$data);
        	$this->session->set_flashdata(array("dsuccess"=>1));
			redirect('Admin/employee');
	}

	//end employee

	public function quarantine()
	{
	    
	$data['result']=$this->Quarantine_Model->fetch_data();
	$data['users'] = $this->custom->get_login_users();
	$this->load->view('admin/quarantine',$data);
	}

	public function new_office()
	{
		$this->load->view('admin/new_office');
	}



	public function new_office_insert()
	{
		//$name=$this->input->post('name');
		//$location=$this->input->post('location');	
		$this->load->library('form_validation');
		$this->form_validation->set_rules('name', 'Building / Chawl / Bunglow Name', 'required');
		$this->form_validation->set_rules('address', 'Contact No 2', 'numeric|required|min_length[10]',array('min_length'=>"The %s should be 10 characters in length"));
		$this->form_validation->set_rules('emailid', 'Contact No 1', 'numeric|required|min_length[10]',array('min_length'=>"The %s should be 10 characters in length"));
		$this->form_validation->set_rules('contact', 'Flat / Room No', 'required');
		$this->form_validation->set_rules('city', 'Area Name', 'required');
		$this->form_validation->set_rules('longitude', 'Longitude', 'required');
		$this->form_validation->set_rules('latitude', 'Latitude', 'required');
		if ($this->form_validation->run() == FALSE)
		{
		    $this->load->view('admin/new_office');
		}
		else
		{
		$this->Quarantine_Model->insert();
		$this->session->set_flashdata(array("success"=>1));
		redirect("Admin/quarantine");       
		}
	}
		
		public function editquarantine($id)
	{		
		$result['data']=$this->Quarantine_Model->display_office_recordsById($id);
	
		$this->load->view('admin/update_office_record',$result);
	}
		
	

	public function update_data($id)
	{
	    
	    $this->load->library('form_validation');
		$this->load->library('form_validation');
		$this->form_validation->set_rules('name', 'Building / Chawl / Bunglow Name', 'required');
		$this->form_validation->set_rules('address', 'Contact No 2', 'numeric|required|min_length[10]',array('min_length'=>"The %s should be 10 characters in length"));
		$this->form_validation->set_rules('emailid', 'Contact No 1', 'numeric|required|min_length[10]',array('min_length'=>"The %s should be 10 characters in length"));
		$this->form_validation->set_rules('contact', 'Flat / Room No', 'required');
		$this->form_validation->set_rules('city', 'Area Name', 'required');
		$this->form_validation->set_rules('longitude', 'Longitude', 'required');
		$this->form_validation->set_rules('latitude', 'Latitude', 'required');
		if ($this->form_validation->run() == FALSE)
		{
		    $result['data']=$this->Quarantine_Model->display_office_recordsById($id);
		    $this->load->view('admin/update_office_record',$result);
		}
		else
		{
		$this->Quarantine_Model->update($id);
		$this->session->set_flashdata(array("usuccess"=>1));
		redirect("Admin/quarantine");
		}
	}

	public function delete($id)
	{
		/*$this->db->query("delete from mst_office where id='".$id."'");
		redirect("Admin/office");*/
		
			$data=array(
		            "deleted_SI"=>$this->session->userdata('id'),
					"deleted_by"=>$this->session->userdata('name'),
					"deleted_DT"=>date('Y-m-d H:s:i'));
		$this->db->where('id',$id)->update('mst_office',$data);
		$this->session->set_flashdata(array("dsuccess"=>1));
		redirect('Admin/quarantine');
		
	}


	//Guard Pannel

	public function guard()
	{
    	
    	$data['result']=$this->Guard_Model->fetch_data();
    	$data['users']=$this->custom->get_login_users();
    		//print_r($data);
    	$this->load->view('admin/guard',$data);
	}
	

	public function new_guard()
	{
	    $data['hospital'] = $this->db->select('*')->where('type',1)->where('Deleted_DT',NULL)->get('mst_hospital')->result();
		$this->load->view('admin/new_guard',$data);
	}

	public function new_guard_insert()
	{
	    $ptype = $this->input->post('ptype');
        $hostatus = $this->input->post('currhos');
	    $this->load->library('form_validation');
		$this->form_validation->set_rules('name', 'Name', 'required');
		$this->form_validation->set_rules('address', 'Address', 'required');
		$this->form_validation->set_rules('contact', 'Mobile Number', 'numeric|is_unique[mst_guard.contact],array("is_unique" => "This %s already exists.")|required|regex_match[/^[0-9]{10}$/]|min_length[10]',array('min_length'=>"The %s should be 10 characters in length"));
	//	$this->form_validation->set_rules('contact', 'Mobile Number', 'numeric|required|min_length[10]',array('min_length'=>"The %s should be 10 characters in length"));
	//	$this->form_validation->set_rules('DOJ', 'Detected Date', 'required');  
		$this->form_validation->set_rules('DOB', 'Observation Started From', 'required');
		$this->form_validation->set_rules('receiptdate', 'Date Of Receipt Of Information', 'required');
		$this->form_validation->set_rules('username', 'Username', 'required');
		$this->form_validation->set_rules('password', 'Password', 'required|min_length[8]');
		$this->form_validation->set_rules('status', 'Status', 'required');
        $this->form_validation->set_rules('age', 'Age', 'required');
        $this->form_validation->set_rules('ptype', 'Suspect Type', 'required');
        $this->form_validation->set_rules('gender', 'Gender', 'required');
        $this->form_validation->set_rules('infosource', 'Information source', 'required');
        $this->form_validation->set_rules('currhos', 'Hospital status', 'required');
        $this->form_validation->set_rules('migstatus', 'Migration status', 'required');
        $this->form_validation->set_rules('trace', 'Traceable', 'required');
        
        
         if($ptype=='Traveler')
        {
            $this->form_validation->set_rules('traveldate', 'Date of Arrival From Affected Country', 'required');
            $this->form_validation->set_rules('leavingdate', 'Date of Leaving Affected Country', 'required');
            $this->form_validation->set_rules('travelfrom', 'Travel From', 'required');
            $this->form_validation->set_rules('travelhis', 'Travel History', 'required');
        }

        if($hostatus==1)
        {
            $this->form_validation->set_rules('hosname', 'Hospital Name', 'required');
            $this->form_validation->set_rules('hospitaldate', 'Date of hospitalization', 'required');
            
        }

		
        if ($this->form_validation->run() == FALSE)
        {
            $data['hospital'] = $this->db->select('*')->where('type',1)->where('Deleted_DT',NULL)->get('mst_hospital')->result();
		 	$this->load->view('admin/new_guard',$data);
        }
        else
        {
	    	$this->Guard_Model->insert();
		    $this->session->set_flashdata(array("success"=>1));
		    redirect("Admin/guard"); 
        }
	}

	public function editguard($id)
	{
	    $result['hospital'] = $this->db->select('*')->where('type',1)->where('Deleted_DT',NULL)->get('mst_hospital')->result();
		$result['data']=$this->Guard_Model->display_guard_recordsById($id);
		$this->load->view('admin/update_guard_record',$result);
	}

	public function update_guard_data($id)	
	{
	    $ptype = $this->input->post('ptype');
        $hostatus = $this->input->post('currhos');

	    $this->load->library('form_validation');
		$this->form_validation->set_rules('name', 'Name', 'required');
		$this->form_validation->set_rules('address', 'Address', 'required');
	    $this->form_validation->set_rules('contact', 'Mobile Number', 'numeric|required|min_length[10]',array('min_length'=>"The %s should be 10 characters in length"));
	   //	$this->form_validation->set_rules('contact', 'Mobile Number', 'numeric|is_unique[mst_guard.contact],array("is_unique" => "This %s already exists.")|required|regex_match[/^[0-9]{10}$/]|min_length[10]',array('min_length'=>"The %s should be 10 characters in length"));
		$this->form_validation->set_rules('status', 'Status', 'required');
	//	$this->form_validation->set_rules('DOJ', 'Detected Date', 'required');
        $this->form_validation->set_rules('age', 'Age', 'required');
		$this->form_validation->set_rules('DOB', 'Observation Started From', 'required');
		$this->form_validation->set_rules('receiptdate', 'Date Of Receipt Of Information', 'required');
		$this->form_validation->set_rules('username', 'Username', 'required');
		$this->form_validation->set_rules('password', 'Password', 'required|min_length[8]');
		$this->form_validation->set_rules('ptype', 'Suspect Type', 'required');
		$this->form_validation->set_rules('gender', 'Gender', 'required');
        $this->form_validation->set_rules('infosource', 'Information source', 'required');
        $this->form_validation->set_rules('currhos', 'Hospital status', 'required');
        $this->form_validation->set_rules('migstatus', 'Migration status', 'required');
        $this->form_validation->set_rules('trace', 'Traceable', 'required');

        if($ptype=='Traveler')
        {
            $this->form_validation->set_rules('traveldate', 'Date of Arrival From Affected Country', 'required');
            $this->form_validation->set_rules('leavingdate', 'Date of Leaving Affected Country', 'required');
            $this->form_validation->set_rules('travelfrom', 'Travel From', 'required');
            $this->form_validation->set_rules('travelhis', 'Travel History', 'required');
        }

        if($hostatus==1)
        {
            $this->form_validation->set_rules('hosname', 'Hospital Name', 'required');
            $this->form_validation->set_rules('hospitaldate', 'Date of hospitalization', 'required');
        }        

        if ($this->form_validation->run() == FALSE)
        {
            $result['hospital'] = $this->db->select('*')->where('type',1)->where('Deleted_DT',NULL)->get('mst_hospital')->result();
            $result['data']=$this->Guard_Model->display_guard_recordsById($id);
            $this->load->view('admin/update_guard_record',$result);
        }
        else
        {
		    $this->Guard_Model->update($id);
		    $this->session->set_flashdata(array("usuccess"=>1));
		    redirect("Admin/guard");
        }
	}

	public function delete_guard($id)
	{
		//$this->db->query("delete from mst_guard where id='".$id."'");
	//	redirect("Admin/guard");	
	
	$data=array(
		            "deleted_SI"=>$this->session->userdata('id'),
					"deleted_by"=>$this->session->userdata('name'),
					"deleted_DT"=>date('Y-m-d H:s:i'));
		$this->db->where('id',$id)->update('mst_guard',$data);
		$this->session->set_flashdata(array("dsuccess"=>1));
		redirect('Admin/guard');
	}
	
	public function validguard_name()
	{
	    // $d=date("Y-m-d");
	     
	    $name=$this->input->post('guard_name');
	    $getdate=$this->input->post('assign_date');
	    
	  
	    
	   $data=$this->db->where('Deleted_DT',NULL)->where('guard_name',$name)->where('assign_date',$getdate)->get('tr_assign_duty')->result();
	   
	   if(count($data)>0)
	   {
	       $message = 1;
	   }
	   else
	   {
	       $message = 0;
	   }
	   echo $message;
	   //print_r($data);
	    
	}
	//----Designation Master

	public function designation()
	{
		$data['result']=$this->Designation_Model->fetch_data();
		//print_r($data);
		
		$this->load->view('admin/designation',$data);
	}
	public function new_Designation()
	{
		$this->load->view('admin/new_Designation');
	}
	public function new_designation_insert()
	{
	    $this->load->library('form_validation');
		$this->form_validation->set_rules('designation', 'Designation', 'required');
        if ($this->form_validation->run() == FALSE)
        {
            $this->load->view('admin/new_Designation');
        }
            
        else
        {
         $this->Designation_Model->insert();	 
		$this->session->set_flashdata(array("success"=>1));
		redirect("Admin/designation");
         }
	}
	
		public function update_destination_data($id)	
	{
	    $this->load->library('form_validation');
		$this->form_validation->set_rules('designation', 'Designation', 'required');
        if ($this->form_validation->run() == FALSE)
        {
        $result['data']=$this->Designation_Model->display_designation_recordsById($id);
		$this->load->view('admin/update_designation_record',$result);
        }
		else
		{
		$this->Designation_Model->update($id);	
		$this->session->set_flashdata(array("usuccess"=>1));
		redirect("Admin/designation");
		}
	}
	
	
	public function editdesignation($id)
	{
		$result['data']=$this->Designation_Model->display_designation_recordsById($id);
		$this->load->view('admin/update_designation_record',$result);
	}
	public function delete_designation($id)
	{
	//	$this->db->query("delete from mst_designation where id='".$id."'");
		//redirect("Admin/designation");	
		
		$data=array(
		            "deleted_SI"=>$this->session->userdata('id'),
					"deleted_by"=>$this->session->userdata('name'),
					"deleted_DT"=>date('Y-m-d H:s:i'));
		$this->db->where('id',$id)->update('mst_designation',$data);
		$this->session->set_flashdata(array("dsuccess"=>1));
		redirect('Admin/designation');
		
	}

	// Assign Duty
	public function assign_duty()
	{
		$data['result']=$this->Duty_Model->fetch_data();
		$data['users']=$this->custom->get_login_users();
    	$this->load->view('admin/assign_duty',$data);
	}
	
	public function changestatus()
	{
	    $data['guard_arr']=$this->Duty_Model->get_patient();
    	$this->load->view('admin/transfer_location',$data);
	    
	}
	

	
	
	
	public function updatetranstatus($id)
	{
	    $data['info'] = $this->db->select('*')->where('deleted_DT',NULL)->where('guard_name',$id)->get('tr_assign_duty')->row();
	    $data['guard_arr']=$this->Duty_Model->get_patient_status();
    	$this->load->view('admin/transfer_location',$data);
	    
	}
	
	
	public function getinfo()
	{
	    $guard_name = $this->input->post('guard_name');
	    
	    $getinfo = $this->db->select('*')->where('transfer_status >',1)->where('guard_name',$guard_name)->where('deleted_DT',NULL)->get('tr_assign_duty')->result();
	    
	    if(count($getinfo)>0)
	    {
	        $show = $this->db->select('mst.id ,mst.patient_status as pstatus,mst.name as pname,mst.contact as cnumber, mst.age, mst.address,off.area_name as areainfo,off.hos_name as bname,off.contact as room')->join('tr_assign_duty msd','mst.id=msd.guard_name')
	        ->join('mst_hospital off','msd.office_name=off.hos_id')->where('mst.id',$guard_name)
	        ->where('mst.deleted_DT',NULL)->order_by('mst.id',"desc")->get('mst_guard mst')->result();
	    }
	    else
	    {
	        $show = $this->db->select('mst.id ,mst.patient_status as pstatus,mst.name as pname,mst.contact as cnumber, mst.age, mst.address,off.city as areainfo,off.name as bname,off.contact as room')
	        ->join('tr_assign_duty msd','mst.id=msd.guard_name')->join('mst_office off','msd.office_name=off.id')
	        ->where('mst.id',$guard_name)->where('mst.deleted_DT',NULL)->order_by('mst.id',"desc")->get('mst_guard mst')->result();

	    }
  	    echo json_encode(array_shift($show));
	}
	
	
	public function getinfo2()
	{
	    $guard_name = $this->input->post('guard_name');
	    
	    $show = $this->db->select('mst.id ,mst.patient_status as pstatus,mst.name as pname,mst.contact as cnumber, mst.age, mst.address,off.area_name as areainfo,off.hos_name as bname,off.contact as room')->join('tr_assign_duty msd','mst.id=msd.guard_name')->join('mst_hospital off','msd.office_name=off.hos_id')->where('mst.id',$guard_name)->where('mst.deleted_DT',NULL)->order_by('mst.id',"desc")->get('mst_guard mst')->result();
  
  	    echo json_encode(array_shift($show));
	}
    
    public function getsuspectinfo()
	{
	    $guard_name = $this->input->post('guard_name');
	    
	    $show = $this->db->select('*')->where('mst.id',$guard_name)->where('mst.deleted_DT',NULL)->get('mst_guard mst')->result();
  	    echo json_encode(array_shift($show));
	}
	
	
	
	public function gethighriskinfo()
	{
	    $guard_name = $this->input->post('guard_name');
	    
	    $show = $this->db->select('*')->where('mst.add_id',$guard_name)->where('mst.deleted_DT',NULL)->get('tbl_risk_addmore mst')->result();
  	    echo json_encode(array_shift($show));
	}
	
	
	
	
		public function new_duty()
	{
		$data['duty_arr']=$this->Duty_Model->fetch_office_name();	
		$data['guard_arr']=$this->Duty_Model->fetch_guard_name();
		$this->load->view('admin/new_duty',$data);
	}

	public function new_duty_insert()	
	{
		$this->load->library('form_validation');
		$this->form_validation->set_rules('office_name', 'Quarantine Location', 'required');
		$this->form_validation->set_rules('guard_name', 'Patient ', 'required');
// 		$this->form_validation->set_rules('assign_date', 'Assign Date', 'required');
		if ($this->form_validation->run() == FALSE)
		{
		$data['duty_arr']=$this->Duty_Model->fetch_office_name();	
		$data['guard_arr']=$this->Duty_Model->fetch_guard_name();
		$this->load->view('admin/new_duty',$data);
		}
		else
		{
		    
	//$query=$this->db->where('assign_date',$_POST['assign_date'])->get('tr_assign_duty')->result();
		$data['rd']=$this->Duty_Model->insert();
		$this->session->set_flashdata(array("success"=>1));
		redirect("Admin/assign_duty");   
		}
	 }

	
	public function delete_duty($id)
	{
	//	$this->db->query("delete from tr_assign_duty where d_id='".$id."'");
	//redirect("Admin/assign_duty");	
	$data=array(
		            "deleted_SI"=>$this->session->userdata('id'),
					"deleted_by"=>$this->session->userdata('name'),
					"deleted_DT"=>date('Y-m-d H:s:i'));
		$this->db->where('d_id',$id)->update('tr_assign_duty',$data);
		$this->session->set_flashdata(array("dsuccess"=>1));
		redirect('Admin/assign_duty');
	}

	

	
	public function complaint()
	{	
		$users=$this->Complaint_Model->get_new_msg_users();		
		$data['new_msg_users'] = array();
		if(!empty($users)) {
		    foreach($users as $user) {
		        $data['new_msg_users'][] = $user->guard_name;
		    }
		}
		
		$data['result']=$this->Complaint_Model->fetch_data();
		$this->load->view('admin/complaint',$data);	
	}
	
	public function update_view_flag() {
	    $this->db->where('guard_name', $_POST['id'])->update('mst_complaint', array('admin_view_flag' => 1));
	    echo '1';exit;
	}
	
	
	public function chat($userid) {
		$data = $this->Complaint_Model->get_chat_by_userid($userid);
		$this->load->view('admin/chat', $data);
	}
	
	public function save_chat_msg($userid) {
	    $this->Complaint_Model->save_chat_msg($userid);
	    $this->session->set_flashdata(array("success"=>1));
	   // redirect("");
	    redirect("Admin/chat/$userid");
	}
	
	public function show_detail_comp()
	{	

		$id = $this->input->post('id');
		$result=$this->Complaint_Model->display_recordsById($id);
		//print_r($result);
		
		
            $view ='<div class="form-body">
                    <div class="row">
                          <div class="col-sm-12">
                                <div class="form-group">
                                	
                                	<label class="control-label"> Name : </label> &nbsp <label class="control-label"><b> '.$result->name.' </b> </label><br>
                                	<label class="control-label"> Complaint : </label> &nbsp<label class="control-label"><b> '.$result->complaint.' </b></label><br>
                                	<label class="control-label"> Complaint Description : </label> &nbsp<label class="control-label"><b> '.$result->complaint_desc.' </b></label>
                         </div>
                    </div>
                    </div>
                    </div>
            
            ';
			echo $view;
	
	}
	public function editduty($id)
	{
	  
		$result['duty_arr']=$this->Duty_Model->fetch_office_name();	
		$result['guard_arr']=$this->Duty_Model->fetch_guard_name();	
		$result['data']=$this->Duty_Model->display_duty_recordsById($id);	
		$this->load->view('admin/update_duty_record',$result);
	}
	public function update_duty_data($id)	
	{
	    $this->load->library('form_validation');
		$this->form_validation->set_rules('office_name', 'Quarantine Location', 'required');
		$this->form_validation->set_rules('guard_name', 'Patient Name', 'required');
// 		$this->form_validation->set_rules('assign_date', 'Assign Date', 'required');
		
		if ($this->form_validation->run() == FALSE)
		{
		$result['duty_arr']=$this->Duty_Model->fetch_office_name();	
		$result['guard_arr']=$this->Duty_Model->fetch_guard_name();	
	    $result['data']=$this->Duty_Model->display_duty_recordsById($id);	
		$this->load->view('admin/update_duty_record',$result);
		}
		else
		{
		$this->Duty_Model->update($id);	
		$this->session->set_flashdata(array("usuccess"=>1));
		redirect("Admin/assign_duty");
		}
	}

	///----Announcement

	public function announcement()
	{
		//$data['duty_arr']=$this->duty_model->fetch_office_name();	
		//$this->load->view('admin/announcements',$data);

		$data['result']=$this->Announcement_Model->fetch_data();
		//print_r($data);
		$this->load->view('admin/announcement_grid',$data);


	}

	public function new_announcement()
	{
		$data['duty_arr']=$this->Duty_Model->fetch_office_name();	
		$this->load->view('admin/announcements',$data);
	}

	public function editannouncement($id)
	{
		$result['duty_arr']=$this->Duty_Model->fetch_office_name();			
		$result['data']=$this->Announcement_Model->display_recordsById($id);
// echo '<pre>';
// print_r($result['data']);
		$this->load->view('admin/update_announcement_record',$result);
	}


	public function announcement_insert()
	{
	//$logid = $this->session->userdata('id');
		 $this->load->library('form_validation');
		 
		$this->form_validation->set_rules('type', 'Type', 'required');
		
		if(isset($_POST['type']))
		{
		    $checktype = $_POST['type'];
		}
		else
		{
		    $checktype='';
		}
		
		
		if($checktype=='Location')
		{
		    	$this->form_validation->set_rules('type', 'Type', 'required');
		        $this->form_validation->set_rules('title', 'Title', 'required');
		        $this->form_validation->set_rules('office_name', 'Quarantine', 'required');
		        $this->form_validation->set_rules('description', 'Description', 'required');
		}
		else if($checktype!='Location')
		{
		       	$this->form_validation->set_rules('type', 'Type', 'required');
	        	$this->form_validation->set_rules('title', 'Title', 'required');
		        //$this->form_validation->set_rules('office_name', 'Office', 'required');
		        $this->form_validation->set_rules('description', 'Description', 'required');
		}
		else
		{
		    	$this->form_validation->set_rules('type', 'Type', 'required');
		    	$this->form_validation->set_rules('title', 'Title', 'required');
		    	$this->form_validation->set_rules('description', 'Description', 'required');
		}
	
        if ($this->form_validation->run() == FALSE)
        {
            if($checktype=='Location')
		    {
		        $data['typeval'] = $checktype;
		    }
            $data['duty_arr']=$this->Duty_Model->fetch_office_name();	
		    $this->load->view('admin/announcements',$data);
        }
        else
        {
			$data = array(
			            "type"=>$_POST['type'],
		               "a_office"=>$_POST['office_name'],
					   "a_title"=>$_POST['title'],
					   "a_desc"=>$_POST['description'],
					   "Inserted_SI"=>$this->session->userdata('id'),
                       "Inserted_BY"=>$this->session->userdata('name'),
                       "inserted_DT"=>date('Y-m-d H:i:s')
		             );
        if($this->db->insert('announcement',$data))
		{   
	        $this->session->set_flashdata(array("success"=>1));
			redirect('Admin/announcement');
		}
        }
	}
	
	

	public function update_announcement($id)	
	{	
	     $this->load->library('form_validation');
		$this->form_validation->set_rules('type', 'Type', 'required');
		$this->form_validation->set_rules('office_name', 'Office Name', 'required');
		$this->form_validation->set_rules('title', 'Title', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
        if ($this->form_validation->run() == FALSE)
        {
            $result['duty_arr']=$this->Duty_Model->fetch_office_name();			
		    $result['data']=$this->Announcement_Model->display_recordsById($id);     
            $this->load->view('admin/update_announcement_record',$result);
        }
        else
        {
          //  echo "1";
            //exit;
		$this->Announcement_Model->update($id);	
		$this->session->set_flashdata(array("usuccess"=>1));
		redirect("Admin/announcement");
        }
	}

	public function delete_announcement($id)
	{

		$data=array(
		            "deleted_SI"=>$this->session->userdata('id'),
					"deleted_BY"=>$this->session->userdata('name'),
					"deleted_DT"=>date('Y-m-d H:s:i'));
		$this->db->where('a_id',$id)->update('announcement',$data);
		$this->session->set_flashdata(array("dsuccess"=>1));
		redirect('Admin/announcement');
	}
	//================================Reports==================

		public function total_guard()
		{		
    		if(!empty($_POST['date']))
    		{
    	        $data['date'] = $_POST['date'];
    	    }
	    	if(!empty($_POST['date']))
				{
					$getdate = $_POST['date'];
				}
				else{
					$getdate ='';
				}
				
    	    $data['srch_date']=$getdate;
    		$guards=$this->Guard_Model->fetch_total_guard();
    		
    		            
            $data['offices'] = array();
            $offices = $this->db->where('Deleted_DT IS NULL')->get('mst_office')->result();
            if(!empty($offices)) {
                foreach($offices as $office) {
                    $data['offices'][$office->id] = $office; 
                }
            }
            
            $data['assign_quarantine'] = array();
            $assign_q = $this->db->where('Deleted_DT IS NULL')->get('tr_assign_duty')->result();
            if(!empty($assign_q)) {
                foreach($assign_q as $assign) {
                    $data['assign_quarantine'][$assign->guard_name] = !empty($data['offices'][$assign->office_name]) ? $data['offices'][$assign->office_name] : '';  
                }
            }
            
            foreach($guards as $guard) {
                $data['guard_arr'][$guard->id]['guard'] = $guard;
                $data['guard_arr'][$guard->id]['quarantine'] = !empty($data['assign_quarantine'][$guard->id]) ? $data['assign_quarantine'][$guard->id] : '';
                // $data
            }
            
    		//print_r($data);
    		$this->load->view('admin/report/total_guard_report',$data);
		}
		
		
		public function q_cmplt_ptnts()
		{		
    // 		$data['guard_arr']=$this->Guard_Model->completed_quarantine_patients();
    		
    		
    		$guards= $this->Guard_Model->completed_quarantine_patients();
    		
            $data['offices'] = array();
            $offices = $this->db->where('Deleted_DT IS NULL')->get('mst_office')->result();
            if(!empty($offices)) {
                foreach($offices as $office) {
                    $data['offices'][$office->id] = $office; 
                }
            }
            
            $data['assign_quarantine'] = array();
            $assign_q = $this->db->where('Deleted_DT IS NULL')->get('tr_assign_duty')->result();
            if(!empty($assign_q)) {
                foreach($assign_q as $assign) {
                    $data['assign_quarantine'][$assign->guard_name] = !empty($data['offices'][$assign->office_name]) ? $data['offices'][$assign->office_name] : '';  
                }
            }
            
            foreach($guards as $guard) {
                $data['guard_arr'][$guard->id]['guard'] = $guard;
                $data['guard_arr'][$guard->id]['quarantine'] = !empty($data['assign_quarantine'][$guard->id]) ? $data['assign_quarantine'][$guard->id] : '';
                // $data
            }
            

    		$this->load->view('admin/report/q_completed_patients',$data);
		}
		
		
	//================================Quarantine Completed==================

		public function quarantine_complete_user()
		{		
    		if(!empty($_POST['date']))
    		{
    	        $data['searchdate'] = $_POST['date'];
    	        $this->db->where('mst_guard.inserted_DT',$_POST['date']);
    	    }
	    	if(!empty($_POST['date']))
				{
					$getdate = $_POST['date'];
				}
				else{
					$getdate ='';
				}
				
    	    $data['srch_date']=$getdate;
    		$data['guard_arr']=$this->Guard_Model->fetch_total_guard();
    		
    		$this->load->view('admin/report/total_guard_report',$data);
		}

		public function date_wise_attendence()
		{
			if(!empty($_POST['date'])){
			  
	        $data['srch_att_date'] = $_POST['date'];
	        //$data['guard_att']=$this->db->where('DATE(PI_DT)',$_POST['date'])->get('attendence')->result();
	        $this->db->select('attendence.*,mst_office.name as o_name,mst_office.city,mst_guard.name');
    	 	$this->db->where('attendence.deleted_DT',NULL);
    	 	$this->db->where('DATE(PI_DT)',$_POST['date']);
    		$this->db->from('attendence');
    		$this->db->join('mst_office','mst_office.id=attendence.office_id ','left');
    	    //	$this->db->join('mst_office','mst_office.city=attendence.office_id','left');
    		$this->db->join('mst_guard','mst_guard.id=attendence.guard_id','left');
    		$this->db->order_by('a_id','DESC');
    		$data['guard_att']=$this->db->get()->result();
	        $this->load->view('admin/report/date_wise_attendence',$data);
	       
	         }
	        else
	        {
	        $getatt_date ='';
	        $data['guard_att']=$this->Guard_Model->fetch_guard_attendence();
		         $this->load->view('admin/report/date_wise_attendence',$data);
	        }
		}
	

		
		public function Guard_hourl_attendence()
		{
		    $data['guard_hr_att']=$this->Guard_Model->fetch_guard_hr_attendence();
	    		
    	    $data['guard_arr']=$this->Duty_Model->fetch_guard_name();	
    	    
    		$this->load->view('admin/report/Guard_hourl_attendence',$data);

		}
		

		
		
		/*public function guard_status()
		{
			if(!empty($_POST['date'])) {
	        
		        $data['searchatt_date'] = $_POST['date'];
		        $this->db->where('mst_guard.DOJ',$_POST['date']);
	    	}

	    	// $data['guard_arr']=$this->duty_model->fetch_guard_name();
	    	$data['guard_status']=$this->Guard_Model->fetch_guard_status();
			$this->load->view('admin/report/guard_status',$data);
		}*/
		
		public function guard_status()
		{
			if(!empty($_POST['date'])) {
	        
		        $data['searchatt_date'] = $_POST['date'];
		        $this->db->where('mst_guard.DOJ',$_POST['date']);
	    	}

	    	// $data['guard_arr']=$this->duty_model->fetch_guard_name();
			//$_POST['date']='';
			if(!empty($_POST['date']))
			{
				$getdate = $_POST['date'];
			}
			else{
				$getdate ='';
			}
			$data['srch_date']=$getdate;
	    	$data['guard_status']=$this->Guard_Model->fetch_guard_status();
			$this->load->view('admin/report/guard_status',$data);
		}
		
		//=======Excel format guard Status=======
		
		function createxls()
      {
            $this->load->library("excel");
            $object = new PHPExcel();                
            $object->setActiveSheetIndex(0);                
            $table_columns = array("Guard Name","Office Name","City","Date","Status");                
            $column = 0;
                
            foreach($table_columns as $field)
            {
                  $object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
                  $column++;
            }
			
			
			$date_get=$_POST['hd_var'];
			if(!empty($date_get)) {
	        
		       $date_get=$_POST['hd_var'];
		      //  $actpay = $this->db->where('DOJ',$date_get)->where('Deleted_DT',NULL)->get('mst_guard')->result();\
		      
		           $this->db->select('tad.d_id,mst_office.name as o_name,mst_office.city,mst_guard.name,mst_guard.DOJ,mst_guard.status');
            	 	$this->db->where('tad.deleted_DT',NULL);
            		$this->db->join('mst_office','mst_office.id=tad.office_name','left');
            		$this->db->join('mst_guard','mst_guard.id=tad.guard_name','left');
            		$this->db->where('mst_guard.DOJ',$date_get);
            		$this->db->order_by("tad.d_id","desc");
            		$this->db->from('tr_assign_duty tad');
            		$actpay= $this->db->get()->result();
            		
		        //echo $this->db->last_query();
		        //exit;
		       // echo $actpay
	    	}
			else{			
	       //$actpay = $this->db->where('inserted_DT',$this->session->userdata('id'))->get('mst_guard')->result();
	       
	   //   $actpay = $this->db->where('Deleted_DT',NULL)->get('mst_guard')->result();
	   
	                $this->db->select('tad.d_id,mst_office.name as o_name,mst_office.city,mst_guard.name,mst_guard.DOJ,mst_guard.status');
            	 	$this->db->where('tad.deleted_DT',NULL);
            		$this->db->join('mst_office','mst_office.id=tad.office_name','left');
            		$this->db->join('mst_guard','mst_guard.id=tad.guard_name','left');
            		$this->db->order_by("tad.d_id","desc");
            		$this->db->from('tr_assign_duty tad');
            		$actpay= $this->db->get()->result();
            
	
	      //  $data['emp_arr']=$this->db->where('Deleted_DT',NULL)->where('emp_id',$id)->get('login_t')->row();
		
			}
	       	//print_r($actpay);
		
	       $excel_row = 2;
	       foreach($actpay as $row)
	       { 
                
                $object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $row->name);
                $object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $row->o_name);
                $object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $row->city);
                $object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $row->DOJ);
                $object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $row->status);
                $excel_row++;
	        }
	                        
	                          $object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
                              header('Content-Type: application/vnd.ms-excel');
                              header('Content-Disposition: attachment;filename="guard_status.xls"');
                              $object_writer->save('php://output');
							  exit;
        }
        
        
            
            //caclulate area in circle
            function distance($lat1, $lon1, $lat2, $lon2)
            {
                 if (($lat1 == $lat2) && ($lon1 == $lon2)) 
                 {
                 return 0;
                 }
                else {
                 $theta = $lon1 - $lon2;
                 $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));
                    $dist = acos($dist);
                    $dist = rad2deg($dist);
                    $miles = $dist * 60 * 1.1515;
                    
                    $meters = $miles * 1.609344 * 1000;
                
                    if ($unit == "K") {
                      return ($miles * 1.609344);
                    } else if ($unit == "N") {
                      return ($miles * 0.8684);
                    } else {
                      return $miles;
                    }
                    }
            }

        
        	//=======Excel format guard Status=======
		
	
            
            
            function createxls_date_wise()
      {
            $this->load->library("excel");
            $object = new PHPExcel();                
            $object->setActiveSheetIndex(0);                
            $table_columns = array("Guard Name","Office Name","city","Start Duty","End Duty","PI_area","Working Hours");                
            $column = 0;
                
            foreach($table_columns as $field)
            {
                  $object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
                  $column++;
            }
			
			$date_get=$_POST['d_att'];
			if(!empty($date_get)) {
		       $date_get=$_POST['d_att'];
		           //$data['guard_att']=$this->db->where('DATE(PI_DT)',$_POST['date'])->get('attendence')->result();
	        $this->db->select('attendence.*,mst_office.name as o_name,mst_office.city,mst_guard.name');
    	 	$this->db->where('attendence.deleted_DT',NULL);
    	 	$this->db->where('DATE(PI_DT)',$date_get);
    		$this->db->join('mst_office','mst_office.id=attendence.office_id ','left');
    	//	$this->db->join('mst_office','mst_office.city=attendence.office_id','left');
    		$this->db->join('mst_guard','mst_guard.id=attendence.guard_id','left');
    		$this->db->order_by('a_id','DESC');
    		$this->db->from('attendence');
    		$actpay= $this->db->get()->result();
		        //echo $this->db->last_query();
		        //exit;
		       // echo $actpay
		 
	       
	    	}
			else{
        $this->db->select('attendence.*,mst_office.name as o_name,mst_office.city,mst_guard.name');
	 	$this->db->where('attendence.deleted_DT',NULL);
		$this->db->join('mst_office','mst_office.id=attendence.office_id ','left');
		$this->db->join('mst_guard','mst_guard.id=attendence.guard_id','left');
		$this->db->order_by('a_id','DESC');
		$this->db->from('attendence');
			$actpay= $this->db->get()->result();	
            	}
	       	//print_r($actpay);
		
	       $excel_row = 2;
	       foreach($actpay as $row)
	       {        
                              
                              $in_time1= !empty($row->PI_DT) ? date('Y-m-d h:i:s',strtotime($row->PI_DT)) : '0000-00-00 00:00:00';
                              $out_time1= !empty($row->PO_DT) ? date('Y-m-d h:i:s',strtotime($row->PO_DT)) : '0000-00-00 00:00:00';
                              
                              if($in_time1=='0000-00-00 00:00:00' || $out_time1=='0000-00-00 00:00:00')
							  {
							      $showhr = "0 Hr : 0 Min";
							  }
							  else
							  {
							    $PI_DT=$row->PI_DT;
							    $PO_DT=$row->PO_DT;
						        $in = new DateTime($PI_DT);
                                $out = new DateTime($PO_DT);
                                $diff = $out->diff($in);
                                $showhr =  $diff->format('%h Hr : %i Min');
							  }
													  
													  
                $object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $row->name);
                $object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $row->o_name);
                $object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $row->city);
               // $object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $row->PI_DT);
                $object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row,  $in_time= !empty($row->PI_DT) ? date('Y-m-d h:i:s',strtotime($row->PI_DT)) : '0000-00-00 00:00:00');
                //$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $row->PO_DT);
                $object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row,  $out_time= !empty($row->PO_DT) ? date('Y-m-d h:i:s',strtotime($row->PO_DT)) : '0000-00-00 00:00:00');
                $object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $row->PI_area);
                $object->getActiveSheet()->setCellValueByColumnAndRow(7, $excel_row,$showhr);
                $excel_row++;
	          }
	                        
	                          $object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
                              header('Content-Type: application/vnd.ms-excel');
                              header('Content-Disposition: attachment;filename="date_wise_attendence.xls"');
                              $object_writer->save('php://output');
							  exit;
            }
            
            
        //===Total Guard==
        
	function createxls_total_guard()
      {
            $this->load->library("excel");
            $object = new PHPExcel();                
            $object->setActiveSheetIndex(0);                
            $table_columns = array("Patient Name","Patient Email","Patient Address","Detected Date");                
            $column = 0;
                
            foreach($table_columns as $field)
            {
                  $object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
                  $column++;
            }
			
			
			
			if(!empty($date_get)) {
		       $date_get=$_POST['hd_var'];
		        $actpay = $this->db->where('DOJ',$date_get)->where('Deleted_DT',NULL)->order_by("id","desc")->get('mst_guard')->result();
		      
		           /*$this->db->select('tad.d_id,mst_office.name as o_name,mst_office.city,mst_guard.name,mst_guard.DOJ,mst_guard.status');
            	 	$this->db->where('tad.deleted_DT',NULL);
            		$this->db->join('mst_office','mst_office.id=tad.office_name','left');
            		$this->db->join('mst_guard','mst_guard.id=tad.guard_name','left');
            		$this->db->where('mst_guard.DOJ',$date_get);
            		$this->db->order_by("tad.d_id","desc");
            		$this->db->from('tr_assign_duty tad');
            		$actpay= $this->db->get()->result();*/
            		
		        //echo $this->db->last_query();
		        //exit;
		       // echo $actpay
	    	}
			else{
	       //$actpay = $this->db->where('inserted_DT',$this->session->userdata('id'))->get('mst_guard')->result();
	       
	    $actpay = $this->db->where('Deleted_DT',NULL)->order_by("id","desc")->get('mst_guard')->result();
	   
	               /* $this->db->select('tad.d_id,mst_office.name as o_name,mst_office.city,mst_guard.name,mst_guard.DOJ,mst_guard.status');
            	 	$this->db->where('tad.deleted_DT',NULL);
            		$this->db->join('mst_office','mst_office.id=tad.office_name','left');
            		$this->db->join('mst_guard','mst_guard.id=tad.guard_name','left');
            		$this->db->order_by("tad.d_id","desc");
            		$this->db->from('tr_assign_duty tad');
            		$actpay= $this->db->get()->result();
            */
	
	      //  $data['emp_arr']=$this->db->where('Deleted_DT',NULL)->where('emp_id',$id)->get('login_t')->row();
		
			}
	       	//print_r($actpay);
		
	       $excel_row = 2;
	       foreach($actpay as $row)
	       {   
                $object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $row->name);
                $object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $row->email);
                $object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $row->address);
                $object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $row->DOJ);
                $excel_row++;
	        }
	                      
	                          $object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
                              header('Content-Type: application/vnd.ms-excel');
                              header('Content-Disposition: attachment;filename="Total_patients.xls"');
                              $object_writer->save('php://output');
							 // exit;
        }
        
        //====== Update Guard Board===
        
        public function validcontact()
	    {
	      $contact=$this->input->post('contact');
	        $g_id=$this->input->post('id');
	    //echo $contact;
	    //echo $g_id;
	    //exit;
	    $message='';
	    $data=$this->db->where('Deleted_DT',NULL)->where('contact',$contact)->where('id !=',$g_id)->get('mst_guard')->result();
	    //print_r($data);
	   // exit;
	   if(count($data)>0)
	   {
	       $message=1;
	   }
	   else
	   {
	       $message=0;
	   }
	   echo $message;
	   
	    
	   }
        
        
       	public function hospital()
	    {
	    
        	$data['result']=$this->Hospital_model->fetch_data();
	        $data['users'] = $this->custom->get_login_users();
	        $this->load->view('admin/hospital_grid',$data);
	    }
	    
	    public function isolation_grid()
	    {
	    
        	$data['result']=$this->Hospital_model->isolation_data();
	        $data['users'] = $this->custom->get_login_users();
	        $this->load->view('admin/isolation_grid',$data);
	    }
	    
	    public function govequorantine_grid()
	    {
	    
        	$data['result']=$this->Hospital_model->government_data();
	        $data['users'] = $this->custom->get_login_users();
	        $this->load->view('admin/government_grid',$data);
	    }
	    
	
	    public function new_hospital()
    	{
		    $this->load->view('admin/new_hospital');
	    }
	    
	    
	    public function new_isolation()
    	{
		    $this->load->view('admin/new_isolation');
	    }
	    
	    public function new_governmentqurt()
    	{
		    $this->load->view('admin/new_govtquorantine');
	    }
	    
	    
	    public function new_hospital_insert()
	    {
    		//$name=$this->input->post('name');
    		//$location=$this->input->post('location');	
    		    $this->load->library('form_validation');
    		    $this->form_validation->set_rules('hosname', 'Hospital Name', 'required');
    		    $this->form_validation->set_rules('type', 'Type', 'required');
    		    $this->form_validation->set_rules('contactno', 'Contact No', 'numeric|min_length[10]',array('min_length'=>"The %s should be 10 characters in length"));
    		    $this->form_validation->set_rules('disname', 'District Name', 'required');
    		    //$this->form_validation->set_rules('area', 'Area', 'required');
    		  //  $this->form_validation->set_rules('longitude', 'Longitude', 'required');
    		    //$this->form_validation->set_rules('latitude', 'Latitude', 'required');
    		    if ($this->form_validation->run() == FALSE)
    		    {
    		        $this->load->view('admin/new_hospital');
    		    }
    		    else
    	    	{
    		        $this->Hospital_model->insert();
    		        $this->session->set_flashdata(array("success"=>1));
    		        redirect("Admin/hospital");       
    		    }
	    }
	    
	    
	    public function new_isolation_insert()
	    {
    		//$name=$this->input->post('name');
    		//$location=$this->input->post('location');	
    		    $this->load->library('form_validation');
    		    $this->form_validation->set_rules('hosname', 'Isolation Name', 'required');
    		    $this->form_validation->set_rules('type', 'Type', 'required');
    		    $this->form_validation->set_rules('contactno', 'Contact No', 'numeric|min_length[10]',array('min_length'=>"The %s should be 10 characters in length"));
    		    //$this->form_validation->set_rules('area', 'Area', 'required');
    		  //  $this->form_validation->set_rules('longitude', 'Longitude', 'required');
    		    //$this->form_validation->set_rules('latitude', 'Latitude', 'required');
    		    if ($this->form_validation->run() == FALSE)
    		    {
    		        $this->load->view('admin/new_isolation');
    		    }
    		    else
    	    	{
    		        $this->Hospital_model->insert_isolation();
    		        $this->session->set_flashdata(array("success"=>1));
    		        redirect("Admin/isolation_grid");       
    		    }
	    }
	    
	    
	    public function new_govtquorantine_insert()
	    {
    		//$name=$this->input->post('name');
    		//$location=$this->input->post('location');	
    		    $this->load->library('form_validation');
    		    $this->form_validation->set_rules('hosname', 'Government Quarantine Name', 'required');
    		    $this->form_validation->set_rules('type', 'Type', 'required');
    		    $this->form_validation->set_rules('contactno', 'Contact No', 'numeric|min_length[10]',array('min_length'=>"The %s should be 10 characters in length"));
    		    //$this->form_validation->set_rules('area', 'Area', 'required');
    		  //  $this->form_validation->set_rules('longitude', 'Longitude', 'required');
    		    //$this->form_validation->set_rules('latitude', 'Latitude', 'required');
    		    if ($this->form_validation->run() == FALSE)
    		    {
    		        $this->load->view('admin/new_govtquorantine');
    		    }
    		    else
    	    	{
    		        $this->Hospital_model->insert_govtquorantine();
    		        $this->session->set_flashdata(array("success"=>1));
    		        redirect("Admin/govequorantine_grid");       
    		    }
	    }
	    
	    
	    public function edithospital($id)
	    {		
		    $result['info']=$this->Hospital_model->display_hospital_recordsById($id);
    		$this->load->view('admin/new_hospital',$result);
	    }
	    
	    public function editisolation($id)
	    {		
		    $result['info']=$this->Hospital_model->display_hospital_recordsById($id);
    		$this->load->view('admin/new_isolation',$result);
	    }
	    
	     public function editgovtquorantine($id)
	    {		
		    $result['info']=$this->Hospital_model->display_hospital_recordsById($id);
    		$this->load->view('admin/new_govtquorantine',$result);
	    }

        
        public function new_hospital_update($id)
	    {
    		//$name=$this->input->post('name');
    		//$location=$this->input->post('location');	
    		    $this->load->library('form_validation');
    		    $this->form_validation->set_rules('hosname', 'Hospital Name', 'required');
    		    $this->form_validation->set_rules('type', 'Type', 'required');
    		    $this->form_validation->set_rules('contactno', 'Contact No', 'numeric|min_length[10]',array('min_length'=>"The %s should be 10 characters in length"));
    		    $this->form_validation->set_rules('area', 'Area Name', 'required');
    		    $this->form_validation->set_rules('longitude', 'Longitude', 'required');
    		    $this->form_validation->set_rules('disname', 'District Name', 'required');
    		    
    		    $this->form_validation->set_rules('latitude', 'Latitude', 'required');
    		    if ($this->form_validation->run() == FALSE)
    		    {
    		        $result['info']=$this->Hospital_model->display_hospital_recordsById($id);
    		        $this->load->view('admin/new_hospital',$result);
    		    }
    		    else
    	    	{
    		        $this->Hospital_model->update($id);
    		        $this->session->set_flashdata(array("usuccess"=>1));
    		        redirect("Admin/hospital");       
    		    }
	    }
	    
	    
	    public function new_isolation_update($id)
	    {
    		//$name=$this->input->post('name');
    		//$location=$this->input->post('location');	
    		    $this->load->library('form_validation');
    		    $this->form_validation->set_rules('hosname', 'Isolation Name', 'required');
    		    $this->form_validation->set_rules('type', 'Type', 'required');
    		    $this->form_validation->set_rules('contactno', 'Contact No', 'numeric|min_length[10]',array('min_length'=>"The %s should be 10 characters in length"));
    		   // $this->form_validation->set_rules('area', 'Area Name', 'required');
    		   // $this->form_validation->set_rules('longitude', 'Longitude', 'required');
    		   //$this->form_validation->set_rules('latitude', 'Latitude', 'required');
    		    if ($this->form_validation->run() == FALSE)
    		    {
    		        $result['info']=$this->Hospital_model->display_hospital_recordsById($id);
    		        $this->load->view('admin/new_isolation',$result);
    		    }
    		    else
    	    	{
    		        $this->Hospital_model->update($id);
    		        $this->session->set_flashdata(array("usuccess"=>1));
    		        redirect("Admin/isolation_grid");       
    		    }
	    }
	    
	    
	    public function new_govtquorantine_update($id)
	    {
    		//$name=$this->input->post('name');
    		//$location=$this->input->post('location');	
    		    $this->load->library('form_validation');
    		    $this->form_validation->set_rules('hosname', 'Government Quarantine Name', 'required');
    		    $this->form_validation->set_rules('type', 'Type', 'required');
    		    $this->form_validation->set_rules('contactno', 'Contact No', 'numeric|min_length[10]',array('min_length'=>"The %s should be 10 characters in length"));
    		   // $this->form_validation->set_rules('area', 'Area Name', 'required');
    		   // $this->form_validation->set_rules('longitude', 'Longitude', 'required');
    		   // $this->form_validation->set_rules('latitude', 'Latitude', 'required');
    		    if ($this->form_validation->run() == FALSE)
    		    {
    		        $result['info']=$this->Hospital_model->display_hospital_recordsById($id);
    		        $this->load->view('admin/new_govtquorantine',$result);
    		    }
    		    else
    	    	{
    		        $this->Hospital_model->update($id);
    		        $this->session->set_flashdata(array("usuccess"=>1));
    		        redirect("Admin/govequorantine_grid");       
    		    }
	    }
        
        public function deletehospital($id)
    	{
    		/*$this->db->query("delete from mst_office where id='".$id."'");
    		redirect("Admin/office");*/
    		
    			$data=array(
    		            "deleted_SI"=>$this->session->userdata('id'),
    					"deleted_by"=>$this->session->userdata('name'),
    					"deleted_DT"=>date('Y-m-d H:s:i'));
    		$this->db->where('hos_id',$id)->update('mst_hospital',$data);
    		$this->session->set_flashdata(array("dsuccess"=>1));
    		redirect('Admin/hospital');
    		
    	}
    	
    	
    	 public function deleteisolation($id)
    	{
    		/*$this->db->query("delete from mst_office where id='".$id."'");
    		redirect("Admin/office");*/
    		
    			$data=array(
    		            "deleted_SI"=>$this->session->userdata('id'),
    					"deleted_by"=>$this->session->userdata('name'),
    					"deleted_DT"=>date('Y-m-d H:s:i'));
    		$this->db->where('hos_id',$id)->update('mst_hospital',$data);
    		$this->session->set_flashdata(array("dsuccess"=>1));
    		redirect('Admin/isolation_grid');
    		
    	}
        
        
        public function deletegovtquorantine($id)
    	{
    		/*$this->db->query("delete from mst_office where id='".$id."'");
    		redirect("Admin/office");*/
    		
    			$data=array(
    		            "deleted_SI"=>$this->session->userdata('id'),
    					"deleted_by"=>$this->session->userdata('name'),
    					"deleted_DT"=>date('Y-m-d H:s:i'));
    		$this->db->where('hos_id',$id)->update('mst_hospital',$data);
    		$this->session->set_flashdata(array("dsuccess"=>1));
    		redirect('Admin/govequorantine_grid');
    		
    	}



        
        public function status_grid()
	    {
	    
        	$data['result']=$this->Hospital_model->get_users();
	        $this->load->view('admin/status_grid',$data);
	    }
	    
	    public function addstatus()
	    {
	        $data['health'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('tbl_health_center')->result();
	        $data['guard_arr']=$this->Duty_Model->get_patient2();
	        $data['prabhaginfo'] = $this->db->select('*')->get('tbl_prabhag')->result();
    	    $this->load->view('admin/add_patient_status',$data);
    	}
    	
    	public function updatepatientstatus($id)
    	{
    	    $data['health'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('tbl_health_center')->result();
    	    $data['patientinfo'] = $this->db->where('id',$id)->get('mst_guard')->row();
    	    $data['prabhaginfo'] = $this->db->select('*')->get('tbl_prabhag')->result();
    	    $data['guard_arr']=$this->db->where('deleted_DT',NULL)->get('mst_guard')->result();
    	    $this->load->view('admin/add_patient_status',$data);
    	}
    	
    	public function sendotp()
    	{
    	    $mobileno = $this->input->post('mobileno');
    	    $guard_name = $this->input->post('guard_name');
    	    
    	    $randno = rand (10000,99999);

    	    $getoutput = '';
    	    $data = array('status_otp'=>$randno);
    	    if($this->db->where('id',$guard_name)->update('mst_guard',$data))
    	    {
    	        $msg ='Your Status change OTP is :'.$randno;
    	        $this->sendsms($msg,$mobileno);
    	        $getoutput=1;
    	    }
    	    else
    	    {
    	        $getoutput=0;
    	    }
    	    echo $getoutput;
            
            
    	}
    	
    	public function validotp()
    	{
    	    $otp = $this->input->post('otp');
    	    $guard_name = $this->input->post('guard_name');
    	    
    	    $info = $this->db->where('status_otp',$otp)->where('id',$guard_name)->get('mst_guard')->result();
    	    $data='';
    	    if(count($info)>0)
    	    {
    	        $data =1;
    	    }
    	    else
    	    {
    	        $data =0;
    	    }
    	    echo $data;
    	}
    	
    	
    	
    	
    	public function update_status()	
	    {
    		$this->load->library('form_validation');
    		$this->form_validation->set_rules('guard_name', 'Patient Name', 'required');
            $this->form_validation->set_rules('status', 'Patient Status', 'required');	
            $this->form_validation->set_rules('prabhag', 'Prabhag Name', 'required');	
    		if ($this->form_validation->run() == FALSE)
    		{
    		    $data['guard_arr']=$this->Duty_Model->get_patient();
    	        $this->load->view('admin/add_patient_status',$data);
    		}
    		else
    		{
    		    $id=$this->input->post('guard_name');
    		    $mobile = $this->input->post('mobileno');
    		    $status = $this->input->post('status');
    		    $prabhg = $this->input->post('prabhagid');
    		    
    		    $healthcenter = $this->input->post('healthcenter');
    		    $action_taken = $this->input->post('actiontaken');
    		    
    		    $checkloc = $this->input->post('shiftto');
    		    $newloc = $this->input->post('newloc');
    		    $labtype = $this->input->post('labtype');
    		    $lab_id = $this->input->post('lab_id');
    		    $swabdate = $this->input->post('swabdate');
    		    
    		    $show = $this->db->where('id',$id)->get('mst_guard')->row();
    		    $insertinfo = array('patient_id'=>$id,'previous_status'=>$show->patient_status,'prabhag_id'=>$prabhg,'inserted_dt'=>date('Y-m-d H:i:s'));
    		    $this->db->insert('tbl_previous_status',$insertinfo);
    		    
    		    $datainfo = array('status_update_by'=>$mobile,'Health_center'=>$healthcenter,'action_taken'=>$action_taken,'prabhag_id'=>$prabhg,'patient_status'=>$status,'status_update_date'=>date('Y-m-d H:i:s'));
    		    $this->db->where('id',$id)->update('mst_guard',$datainfo);
    		    
    		    
    		    $checkassign = $this->db->where('guard_name',$id)->where('Deleted_DT',NULL)->get('tr_assign_duty')->result();
    		    if(count($checkassign)>0)
    		    {
    		        $data2 = array('transfer_status'=>$checkloc,'office_name'=>$newloc,'modify_by'=>$this->session->userdata('id'),'modify_SI'=>$this->session->userdata('name'),'modify_DT'=>date('Y-m-d H:i:s'));
		            $this->db->where('guard_name',$id)->update('tr_assign_duty',$data2);
    		    }
    		    else
    		    {
    		        $data2 = array('guard_name'=>$id,'transfer_status'=>$checkloc,'office_name'=>$newloc,'inserted_by'=>$this->session->userdata('id'),'inserted_SI'=>$this->session->userdata('name'),'inserted_DT'=>date('Y-m-d H:i:s'));
		            $this->db->insert('tr_assign_duty',$data2);
    		    }
		        
		        if($action_taken==2)
		        {
		            $check = $this->db->where('Patient_Id',$id)->where('Deleted_DT',NULL)->get('lab_tests')->result();
		            if(count($check)>0)
		            {
		                $data3 = array('Sample_Collection_Flag'=>1,'Date_Collection'=>$swabdate,'Lab_Type'=>$labtype,'Lab_Id'=>$lab_id,'modify_by'=>$this->session->userdata('id'),'modify_SI'=>$this->session->userdata('name'),'modify_DT'=>date('Y-m-d H:i:s'));
		                $this->db->where('Patient_Id',$id)->update('lab_tests',$data3);
		            }
		            else
		            {
		                $data3 = array('Patient_Id'=>$id,'Sample_Collection_Flag'=>1,'Date_Collection'=>$swabdate,'Lab_Type'=>$labtype,'Lab_Id'=>$lab_id,'Inserted_BY'=>$this->session->userdata('id'),'Inserted_SI'=>$this->session->userdata('name'),'Inserted_DT'=>date('Y-m-d'));
		                $this->db->insert('lab_tests',$data3);
		            }
		        }
    		    $this->session->set_flashdata(array("usuccess"=>1));
    		    redirect("Admin/status_grid");   
    		}
	    }
	 
	    
	    public function update_status2($id)	
	    {
    		$this->load->library('form_validation');
    		$this->form_validation->set_rules('guard_name', 'Patient Name', 'required');
    		$this->form_validation->set_rules('prabhagid', 'Prabhag Name', 'required');	
            $this->form_validation->set_rules('status', 'Patient Status', 'required');	
    		if ($this->form_validation->run() == FALSE)
    		{
    		    $data['guard_arr']=$this->Duty_Model->get_patient();
    	        $this->load->view('admin/add_patient_status',$data);
    		}
    		else
    		{
    		    
    		    $id=$this->input->post('guard_name');
    		    $mobile = $this->input->post('mobileno');
    		    $status = $this->input->post('status');
    		    $prabhg = $this->input->post('prabhagid');
    		    
    		    $healthcenter = $this->input->post('healthcenter');
    		    $action_taken = $this->input->post('actiontaken');
    		    
    		    $checkloc = $this->input->post('shiftto');
    		    $newloc = $this->input->post('newloc');
    		    $labtype = $this->input->post('labtype');
    		    $lab_id = $this->input->post('lab_id');
    		    $swabdate = $this->input->post('swabdate');
    	
    	
    		    
    		    $show = $this->db->where('id',$id)->get('mst_guard')->row();
    		    $insertinfo = array('patient_id'=>$id,'previous_status'=>$show->patient_status,'inserted_dt'=>date('Y-m-d H:i:s'));
    		    $this->db->insert('tbl_previous_status',$insertinfo);
    		    
    		    
    		    $datainfo = array('status_update_by'=>$mobile,'Health_center'=>$healthcenter,'action_taken'=>$action_taken,'prabhag_id'=>$prabhg,'prabhag_id'=>$prabhg,'patient_status'=>$status,'status_update_date'=>date('Y-m-d H:i:s'));
    		    $this->db->where('id',$id)->update('mst_guard',$datainfo);
    		    
    		    
    		    
    		    $checkassign = $this->db->where('guard_name',$id)->where('Deleted_DT',NULL)->get('tr_assign_duty')->result();
    		    if(count($checkassign)>0)
    		    {
    		        $data2 = array('transfer_status'=>$checkloc,'office_name'=>$newloc,'modify_by'=>$this->session->userdata('id'),'modify_SI'=>$this->session->userdata('name'),'modify_DT'=>date('Y-m-d H:i:s'));
		            $this->db->where('guard_name',$id)->update('tr_assign_duty',$data2);
    		    }
    		    else
    		    {
    		        $data2 = array('guard_name'=>$id,'transfer_status'=>$checkloc,'office_name'=>$newloc,'inserted_by'=>$this->session->userdata('id'),'inserted_SI'=>$this->session->userdata('name'),'inserted_DT'=>date('Y-m-d H:i:s'));
		            $this->db->insert('tr_assign_duty',$data2);
    		    }
		        
		        if($action_taken==2)
		        {
		            $check = $this->db->where('Patient_Id',$id)->where('Deleted_DT',NULL)->get('lab_tests')->result();
		            if(count($check)>0)
		            {
		                $data3 = array('Sample_Collection_Flag'=>1,'Date_Collection'=>$swabdate,'Lab_Type'=>$labtype,'Lab_Id'=>$lab_id,'modify_by'=>$this->session->userdata('id'),'modify_SI'=>$this->session->userdata('name'),'modify_DT'=>date('Y-m-d H:i:s'));
		                $this->db->where('Patient_Id',$id)->update('lab_tests',$data3);
		            }
		            else
		            {
		                $data3 = array('Patient_Id'=>$id,'Sample_Collection_Flag'=>1,'Date_Collection'=>$swabdate,'Lab_Type'=>$labtype,'Lab_Id'=>$lab_id,'Inserted_BY'=>$this->session->userdata('id'),'Inserted_SI'=>$this->session->userdata('name'),'Inserted_DT'=>date('Y-m-d'));
		                $this->db->insert('lab_tests',$data3);
		            }
		        }
    		    
    		    
    		    $this->session->set_flashdata(array("usuccess"=>1));
    		    redirect("Admin/status_grid");   
    		}
	    }
	 
	 
	 
	 
	 
    public function sendsms($newmessage,$number)
    {
	  
		$user = "ALERTS";
		$password = "123456";
		$sender_id = 'BNCMCS';
		
		$sender = $number;
		$priority = "ndnd";
		
		$key= '4de670c1b46fcf59b7a26147299fc70d';
		$route= 2;
		
	  //  $apikey = '704ed302-6523-44b3-b80e-ad4493803cd5';
		
		$sms_type = "normal";
		$message = $newmessage;
	//	$data = array('user'=>$user,'pass'=>$password,'sender'=>$sender_id,'phone'=>$sender,'text'=>$message,'priority'=>$priority,'stype'=>$sms_type)//;
		
		$data = array('key'=>$key,'route'=>$route,'sender'=>$sender_id,'number'=>$sender,'sms'=>$message);
		   
		
		http://sms.seqtech.in/api/smsapi?key=Account key&route=Route&sender=Sender id&number=Number(s)&sms=Message

	   // http://sms.admarksolution.com/sendSMS?username=Swayam2&message=testmsgg&sendername=SWAYAM&smstype=TRANS&numbers=9987671046&apikey=704ed302-6523-44b3-b80e-ad4493803cd5
		$ch = curl_init('http://sms.seqtech.in/api/smsapi?');
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		
		try
		{     
			$response = curl_exec($ch);
		//	echo var_dump($response);
			curl_close($ch);
			//redirect('Login/checkotp/'.$_POST['mobileno']);
			//echo var_dump($response);
			//echo 'Message has been sent.';
			//return 1; 
			

		}
		catch(Exception $e)
		{
			return 0;
			//echo 'Message: ' .$e->getMessage();
		
		}
                
    
                
    }
    
	public function getquorantineloc()
	{
	    $showdrop = $this->db->where('Deleted_DT',NULL)->order_by('id','desc')->get('mst_office')->result();
	    $data='';
	    
	    if(count($showdrop)>0)
	    {
    	    $data.='<option value="">Select Location</option>';
    	    foreach($showdrop as $row)
    	    {
    	        $data.='<option value="'.$row->id.'">'.$row->name.'</option>';
    	    }
	    }
	    else
	    {
	        $data.='<option value="">Select Location</option>';
	    }
	    echo $data;
	}
	    
	public function gethospital()
	{
	    $showdrop = $this->db->where('type',1)->where('Deleted_DT',NULL)->order_by('hos_id','desc')->get('mst_hospital')->result();
	    $data='';
	    if(count($showdrop)>0)
	    {
    	    $data.='<option value="">Select Location</option>';
    	    foreach($showdrop as $row)
    	    {
    	        $data.='<option value="'.$row->hos_id.'">'.$row->hos_name.'</option>';
    	    }
	    }
	    else
	    {
	        $data.='<option value="">Select Location</option>';
	    }
	    echo $data;
	}
	
	
	public function getisolation()
	{
	    $showdrop = $this->db->where('type',2)->where('Deleted_DT',NULL)->order_by('hos_id','desc')->get('mst_hospital')->result();
	    $data='';
	    if(count($showdrop)>0)
	    {
    	    $data.='<option value="">Select Location</option>';
    	    foreach($showdrop as $row)
    	    {
    	        $data.='<option value="'.$row->hos_id.'">'.$row->hos_name.'</option>';
    	    }
	    }
	    else
	    {
	        $data.='<option value="">Select Location</option>';
	    }
	    echo $data;
	}
	
	
	public function getgovtisolation()
	{
	    $showdrop = $this->db->where('type',3)->where('Deleted_DT',NULL)->order_by('hos_id','desc')->get('mst_hospital')->result();
	    $data='';
	    if(count($showdrop)>0)
	    {
    	    $data.='<option value="">Select Location</option>';
    	    foreach($showdrop as $row)
    	    {
    	        $data.='<option value="'.$row->hos_id.'">'.$row->hos_name.'</option>';
    	    }
	    }
	    else
	    {
	        $data.='<option value="">Select Location</option>';
	    }
	    echo $data;
	}
	
	
	
	
	public function update_transfer()	
	{
		$this->load->library('form_validation');
	//	$this->form_validation->set_rules('checkloc', 'Check Location', 'required');
		$this->form_validation->set_rules('guard_name', 'Patient Name', 'required');
		$this->form_validation->set_rules('newloc', 'New Assign Location', 'required');
// 		$this->form_validation->set_rules('assign_date', 'Assign Date', 'required');


		if ($this->form_validation->run() == FALSE)
		{
	         $data['guard_arr']=$this->Duty_Model->get_patient();
    	     $this->load->view('admin/transfer_location',$data);
		}
		else
		{
		    $id= $this->input->post('guard_name');
		    $newloc = $this->input->post('newloc');
		    
		    if(isset($_POST['checkloc']))
		    {
		        $checkloc = $this->input->post('checkloc');
		    }
		    else if(isset($_POST['checkloc1']))
		    {
		        $checkloc = $this->input->post('checkloc1');
		    }
		    else if(isset($_POST['checkloc2']))
		    {
		        $checkloc = $this->input->post('checkloc2');
		    }
		    else if(isset($_POST['checkloc3']))
		    {
		        $checkloc = $this->input->post('checkloc3');
		    }
		    else if(isset($_POST['checkloc4']))
		    {
		        $checkloc = $this->input->post('checkloc4');
		    }
		    
		    else
		    {
		        $checkloc = '';
		    }
		    $data = array('transfer_status'=>$checkloc,'office_name'=>$newloc,'modify_by'=>$this->session->userdata('id'),'modify_SI'=>$this->session->userdata('name'),'modify_DT'=>date('Y-m-d H:i:s'));
		    $this->db->where('guard_name',$id)->update('tr_assign_duty',$data);
		  
	    	$this->session->set_flashdata(array("success"=>1));
		    redirect("Admin/transfer_status");   
		}
	 }
	 
	 
	public function update_transfer_info($id)	
	{
		$this->load->library('form_validation');
		//$this->form_validation->set_rules('checkloc', 'Check Location', 'required');
		$this->form_validation->set_rules('guard_name', 'Patient Name', 'required');
		$this->form_validation->set_rules('newloc', 'New Assign Location', 'required');
// 		$this->form_validation->set_rules('assign_date', 'Assign Date', 'required');


		if ($this->form_validation->run() == FALSE)
		{
	        $data['info'] = $this->db->select('*')->where('deleted_DT',NULL)->where('guard_name',$id)->get('tr_assign_duty')->row();
	        $data['guard_arr']=$this->Duty_Model->get_patient_status();
    	    $this->load->view('admin/transfer_location',$data);
	    
		}
		else
		{
		    $id= $this->input->post('guard_name');
		    $newloc = $this->input->post('newloc');
		    //$checkloc = $this->input->post('checkloc');
		    
		    if(isset($_POST['checkloc']))
		    {
		        $checkloc = $this->input->post('checkloc');
		    }
		    else if(isset($_POST['checkloc1']))
		    {
		        $checkloc = $this->input->post('checkloc1');
		    }
		    else if(isset($_POST['checkloc2']))
		    {
		        $checkloc = $this->input->post('checkloc2');
		    }
		    else if(isset($_POST['checkloc3']))
		    {
		        $checkloc = $this->input->post('checkloc3');
		    }
		    else if(isset($_POST['checkloc4']))
		    {
		        $checkloc = $this->input->post('checkloc4');
		    }
		    else
		    {
		        $checkloc = '';
		    }
		    
		    $data = array('transfer_status'=>$checkloc,'office_name'=>$newloc,'modify_by'=>$this->session->userdata('id'),'modify_SI'=>$this->session->userdata('name'),'modify_DT'=>date('Y-m-d H:i:s'));
		    $this->db->where('guard_name',$id)->update(' tr_assign_duty',$data);
		   
		   
	    	$this->session->set_flashdata(array("success"=>1));
		    redirect("Admin/transfer_status");   
		}
	 }
	 
	public function transfer_status()
	{
		$data['result']=$this->Duty_Model->fetch_data_status();
		$data['users']=$this->custom->get_login_users();
    	$this->load->view('admin/patient_transfer_grid',$data);
	}
	
	
	    public function total_quoratine()
		{		
    		if(!empty($_POST['date']))
    		{
    		    
    	        $data['date'] = $_POST['date'];
    	        $this->db->where('DATE(tad.inserted_DT)',date('Y-m-d',strtotime($_POST['date'])));
    	    }
	    	if(!empty($_POST['date']))
				{
					$getdate = $_POST['date'];
				}
				else{
					$getdate ='';
				}
				
    	    $data['srch_date']=$getdate;
    		$data['guard_arr']=$this->Guard_Model->fetch_total_guard_location();
    		//print_r($data);
    		$this->load->view('admin/report/total_quorantine_report',$data);
		}
		
		
		
		
		
// 		positive patient report
		
		public function positive_patient_report()
		{		
    // 		$data['guard_arr']=$this->Guard_Model->completed_quarantine_patients();
    		
    		
    		$data['guard_arr'] = $this->Guard_Model->get_positive_patient();
    		
    		
            // $data['offices'] = array();
            // $offices = $this->db->where('Deleted_DT IS NULL')->get('mst_office')->result();
            // if(!empty($offices)) {
            //     foreach($offices as $office) {
            //         $data['offices'][$office->id] = $office; 
            //     }
            // }
            
            // $data['assign_quarantine'] = array();
            // $assign_q = $this->db->where('Deleted_DT IS NULL')->get('tr_assign_duty')->result();
            // if(!empty($assign_q)) {
            //     foreach($assign_q as $assign) {
            //         $data['assign_quarantine'][$assign->guard_name] = !empty($data['offices'][$assign->office_name]) ? $data['offices'][$assign->office_name] : '';  
            //     }
            // }
            
            // foreach($guards as $guard) {
            //     $data['guard_arr'][$guard->id]['guard'] = $guard;
            //  //   $data['guard_arr'][$guard->id]['quarantine'] = !empty($data['assign_quarantine'][$guard->id]) ? $data['assign_quarantine'][$guard->id] : '';
            //     // $data
            // }
            

    		$this->load->view('admin/report/positive_patient_report',$data);
		}

//   end positive patient report

	    
	    	public function newhighrisk()
        	{
        	        $query=$this->db->order_by('risk_id', 'DESC')->limit('1')->get('tbl_patient_risk')->row();
        	        @$pqidstring = explode('RSK', $query->risk_uniq);
        			@$pqid = array($pqidstring[1], 1);
        			$pqid = array_sum($pqid);
        			$pqidlength = strlen($pqid);
        			if($pqidlength == 1)
        			{
        				$uniqidd = '000'.$pqid;
        			}
        			else if($pqidlength == 2)
        			{
        				$uniqidd = '00'.$pqid;
        			}
        			else if($pqidlength == 3)
        			{
        				$uniqidd = '0'.$pqid;
        			}
        			else
        			{
        				$uniqidd = $pqid;
        			}
        			$data['uniq_id']='RSK'.$uniqidd;
        			$data['guard_arr']=$this->Duty_Model->get_patient();
        			$this->load->view('admin/new_high_risk',$data);
        	}
        	
        	
        	
        	
        	
        	
        	
        	public function updaterisk($id)
        	{
                    $data['info'] = $this->db->select('*')->where('risk_id',$id)->get('tbl_patient_risk')->row();    	    
        			$data['guard_arr']=$this->Duty_Model->get_patient();
        			$this->load->view('admin/new_high_risk',$data);
        	}
        	
        	
        	
        	
        	
        	
        	public function update_highrisk($id)	
            	{
            		$this->load->library('form_validation');
            		$this->form_validation->set_rules('guard_name', 'Patient Name', 'required');
            	
            		if ($this->form_validation->run() == FALSE)
            		{
            		    $data['info'] = $this->db->select('*')->where('risk_id',$id)->get('tbl_patient_risk')->row();    	    
        			    $data['guard_arr']=$this->Duty_Model->get_patient();
        			    $this->load->view('admin/new_high_risk',$data);
            		}
            		else
            		{
            		        $uniqid = $this->input->post('hiddenid2');
            		        $patientid = $this->input->post('guard_name');
            		        
            		        
            		        $check = $this->db->where('uniq_id',$uniqid)->where('save_staus',1)->where('deleted_DT',NULL)->get('tbl_risk_addmore')->result();
            		        
            		        if(count($check) > 0)
            		        {
            		             $data = array("modify_SI"=>$this->session->userdata('id'),"modify_BY"=>$this->session->userdata('username'),"modify_DT"=>date('Y-m-d H:i:s'));
                	             $this->db->where('risk_id',$id)->update('tbl_patient_risk',$data);
                	        
                	             $data2 = array('save_staus'=>1);
                	             $this->db->where('patient_id',$id)->where('uniq_id',$uniqid)->where('save_staus',0)->update('tbl_risk_addmore',$data2);
                	             $this->session->set_flashdata(array("usuccess"=>1));
		                         redirect("Admin/high_risk_grid");     
            		        }
            		        else
            		        {
            		            $data['info'] = $this->db->select('*')->where('risk_id',$id)->get('tbl_patient_risk')->row();    	    
        			            $data['guard_arr']=$this->Duty_Model->get_patient();
        			            $data['errorinfo']= 'Information Not Added';
        			            $this->load->view('admin/new_high_risk',$data);
            		        }
            		        
                	        
                	        
            		}   
            	}
        	
        	
        		public function save_highrisk()	
            	{
            		$this->load->library('form_validation');
            		$this->form_validation->set_rules('guard_name', 'Patient Name', 'required');
            	
            		if ($this->form_validation->run() == FALSE)
            		{
            	         $query=$this->db->order_by('risk_id', 'DESC')->limit('1')->get('tbl_patient_risk')->row();
            	        @$pqidstring = explode('RSK', $query->risk_uniq);
            			@$pqid = array($pqidstring[1], 1);
            			$pqid = array_sum($pqid);
            			$pqidlength = strlen($pqid);
            			if($pqidlength == 1)
            			{
            				$uniqidd = '000'.$pqid;
            			}
            			else if($pqidlength == 2)
            			{
            				$uniqidd = '00'.$pqid;
            			}
            			else if($pqidlength == 3)
            			{
            				$uniqidd = '0'.$pqid;
            			}
            			else
            			{
            				$uniqidd = $pqid;
            			}
            			$data['uniq_id']='RSK'.$uniqidd;
            			$data['guard_arr']=$this->Duty_Model->get_patient();
            			$this->load->view('admin/new_high_risk',$data);
            		}
            		else
            		{
            		        $uniqid = $this->input->post('hiddenid');
            		        $patientid = $this->input->post('guard_name');
            		       
            		       
            		        $check = $this->db->where('uniq_id',$uniqid)->where('save_staus',0)->where('deleted_DT',NULL)->get('tbl_risk_addmore')->result();
            		        
            		        if(count($check) > 0)
            		        {
                		        $data = array("risk_uniq"=>$uniqid,"patient_id"=>$patientid,"risk_type"=>1,"inserted_SI"=>$this->session->userdata('id'),"inserted_BY"=>$this->session->userdata('username'),"inserted_DT"=>date('Y-m-d H:i:s'));
                    	        $this->db->insert('tbl_patient_risk',$data);
                    	        $data2 = array('save_staus'=>1);
                    	        $this->db->where('uniq_id',$uniqid)->where('save_staus',0)->update('tbl_risk_addmore',$data2);
                    	        $this->session->set_flashdata(array("success"=>1));
    		                    redirect("Admin/high_risk_grid"); 
                    	        
            		        }
            		        else
            		        {
            		                    $query=$this->db->order_by('risk_id', 'DESC')->limit('1')->get('tbl_patient_risk')->row();
                            	        @$pqidstring = explode('RSK', $query->risk_uniq);
                            			@$pqid = array($pqidstring[1], 1);
                            			$pqid = array_sum($pqid);
                            			$pqidlength = strlen($pqid);
                            			if($pqidlength == 1)
                            			{
                            				$uniqidd = '000'.$pqid;
                            			}
                            			else if($pqidlength == 2)
                            			{
                            				$uniqidd = '00'.$pqid;
                            			}
                            			else if($pqidlength == 3)
                            			{
                            				$uniqidd = '0'.$pqid;
                            			}
                            			else
                            			{
                            				$uniqidd = $pqid;
                            			}
                            			$data['uniq_id']='RSK'.$uniqidd;
                            			$data['guard_arr']=$this->Duty_Model->get_patient();
                            			$data['errorinfo']= 'Information Not Added';
                            			$this->load->view('admin/new_high_risk',$data);
            			
            		        }
            		}   
            	}
            	
            	
            
            public function delete_highrisk($id){
            	        $data=array("deleted_SI"=>$this->session->userdata('id'),
                                                "deleted_by"=>$this->session->userdata('username'),
                                                "deleted_DT"=>date('Y-m-d H:i:s'));
                        $c=$this->db->where('risk_id',$id)->update('tbl_patient_risk',$data);
                    	$this->session->set_flashdata(array("dsuccess"=>1));
            			redirect("Admin/high_risk_grid"); 
            	}
        	public function savehighrisk()
        	{
        	                $hiddenid = $this->input->post('hiddenid');
                	        $guard_name = $this->input->post('guard_name');
                	        $membernm = $this->input->post('membernm');
                	        $age = $this->input->post('age');
                	        $gender= $this->input->post('gender');
                	        $mobno= $this->input->post('mobno');
                	        $relation= $this->input->post('relation');
                	        $exposure= $this->input->post('exposure');
                	        $observe= $this->input->post('observe');
                	        $sympt= $this->input->post('sympt');
                	        
                	        $address = $this->input->post('address');
                	        $advise = $this->input->post('advise');
                	        $newloc = $this->input->post('newloc');
                	        
                	        $data = array('save_staus'=>0,'advisal'=>$advise,'address'=>$address,'advise_location'=>$newloc,'uniq_id'=>$hiddenid,'patient_id'=>$guard_name,'risk_type'=>1,'memeber_name'=>$membernm,'age'=>$age,'gender'=>$gender,'mobile_no'=>$mobno,'relationship'=>$relation,'date_of_exposure'=>$exposure,'date_of_observation'=>$observe,'symptoms'=>$sympt,
                	        "inserted_SI"=>$this->session->userdata('id'),"inserted_BY"=>$this->session->userdata('username'),"inserted_DT"=>date('Y-m-d H:i:s'));
                	        $this->db->insert('tbl_risk_addmore',$data);
        	}
        	
        	
        	public function savehighrisk2()
        	{
        	                $hiddenid = $this->input->post('hiddenid');
                	        $guard_name = $this->input->post('guard_name');
                	        $membernm = $this->input->post('membernm');
                	        $age = $this->input->post('age');
                	        $gender= $this->input->post('gender');
                	        $mobno= $this->input->post('mobno');
                	        $relation= $this->input->post('relation');
                	        $exposure= $this->input->post('exposure');
                	        $observe= $this->input->post('observe');
                	        $sympt= $this->input->post('sympt');
                	        $address = $this->input->post('address');
                	        $advise = $this->input->post('advise');
                	        $newloc = $this->input->post('newloc');
                	       
                	        $data = array('save_staus'=>1,'advisal'=>$advise,'address'=>$address,'advise_location'=>$newloc,'uniq_id'=>$hiddenid,'patient_id'=>$guard_name,'risk_type'=>1,'memeber_name'=>$membernm,'age'=>$age,'gender'=>$gender,'mobile_no'=>$mobno,'relationship'=>$relation,'date_of_exposure'=>$exposure,'date_of_observation'=>$observe,'symptoms'=>$sympt,
                	        "inserted_SI"=>$this->session->userdata('id'),"inserted_BY"=>$this->session->userdata('username'),"inserted_DT"=>date('Y-m-d H:i:s'));
                	        $this->db->insert('tbl_risk_addmore',$data);
        	}
        	
        	public function getriskdata()
        	{
        	    $hiddenid = $this->input->post('hiddenid');
        	    $disp = $this->db->select('*')->where('deleted_DT',NULL)->where('risk_type',1)->where('uniq_id',$hiddenid)->get('tbl_risk_addmore')->result();
        	    
        	    $data = '';
        	    $i=1;
        	    foreach($disp as $show)
        	    {
        	        if($show->gender==1)
        	        {
        	            $gname = 'Male';
        	        }
        	        else if($show->gender==2)
        	        {
        	            $gname = 'Female';
        	        }
        	        
        	        
        	        if($show->relationship==1)
        	        {
        	            $relation='Family Member';
        	        }
        	        else if($show->relationship==2)
        	        {
        	            $relation='Friend';
        	        }
        	        else if($show->relationship==3)
        	        {
        	            $relation='Work Place Colleague';
        	        }
        	        else if($show->relationship==4)
        	        {
        	            $relation='Servant';
        	        }
        	        else if($show->relationship==5)
        	        {
        	            $relation='Other';
        	        }
        	        else 
        	        {
        	            $relation='';
        	        }
        	        
        	        if($show->advisal==1)
        	        {
        	            $advise = 'Hospital';
        	            $locationinfo = $this->db->select('*')->where('hos_id',$show->advise_location)->where('type',1)->get('mst_hospital')->row();
        	            $hosname = $locationinfo->hos_name;
        	        }
        	        else if($show->advisal==2)
        	        {
        	            $advise = 'Isolation';
        	            $locationinfo = $this->db->select('*')->where('hos_id',$show->advise_location)->where('type',1)->get('mst_hospital')->row();
        	            $hosname = $locationinfo->hos_name;
        	        }
        	        else if($show->advisal==3)
        	        {
        	            $advise = 'Governemt Quarantine';
        	            $locationinfo = $this->db->select('*')->where('hos_id',$show->advise_location)->where('type',1)->get('mst_hospital')->row();
        	            $hosname = $locationinfo->hos_name;
        	        }
        	        else
        	        {
        	            $advise='';
        	            $hosname='';
        	        }
        	        
        	        
        	        $data.='<tr>
        	                    <td>'.$i++.'</td>
        	                    <td>'.$show->memeber_name.'</td>
        	                    <td>'.$show->age.'</td>
        	                    <td>'.$gname.'</td>
        	                    <td>'.$show->mobile_no.'</td>
        	                    <td>'.$relation.'</td>
        	                    <td>'.$show->date_of_exposure.'</td>
        	                    <td>'.$show->date_of_observation.'</td>
        	                    <td>'.$show->symptoms.'</td>
        	                    <td>'.$advise.'</td>
        	                    <td>'.$hosname.'</td>
        	                    <td><button type="button" class="btn btn-danger" onclick="delrec('.$show->add_id.')">Delete</button></td>
        	                </tr>';
        	    }
        	    echo $data;
        	}
        	
        	
        	public function getriskdata2()
        	{
        	    $hiddenid = $this->input->post('hiddenid');
        	    $disp = $this->db->select('*')->where('deleted_DT',NULL)->where('save_staus',1)->where('risk_type',1)->where('uniq_id',$hiddenid)->get('tbl_risk_addmore')->result();
        	    
        	    $data = '';
        	    $i=1;
        	    foreach($disp as $show)
        	    {
        	        if($show->gender==1)
        	        {
        	            $gname = 'Male';
        	        }
        	        else if($show->gender==2)
        	        {
        	            $gname = 'Female';
        	        }
        	        
        	        if($show->relationship==1)
        	        {
        	            $relation='Family Member';
        	        }
        	        else if($show->relationship==2)
        	        {
        	            $relation='Friend';
        	        }
        	        else if($show->relationship==3)
        	        {
        	            $relation='Work Place Colleague';
        	        }
        	        else if($show->relationship==4)
        	        {
        	            $relation='Servant';
        	        }
        	        else if($show->relationship==5)
        	        {
        	            $relation='Other';
        	        }
        	        else 
        	        {
        	            $relation='';
        	        }
        	        
        	        if($show->advisal==1)
        	        {
        	            $advise = 'Hospital';
        	            $locationinfo = $this->db->select('*')->where('hos_id',$show->advise_location)->where('type',1)->get('mst_hospital')->row();
        	            $hosname = $locationinfo->hos_name;
        	        }
        	        else if($show->advisal==2)
        	        {
        	            $advise = 'Isolation';
        	            $locationinfo = $this->db->select('*')->where('hos_id',$show->advise_location)->where('type',2)->get('mst_hospital')->row();
        	            $hosname = $locationinfo->hos_name;
        	        }
        	        else if($show->advisal==3)
        	        {
        	            $advise = 'Governemt Quarantine';
        	            $locationinfo = $this->db->select('*')->where('hos_id',$show->advise_location)->where('type',3)->get('mst_hospital')->row();
        	            $hosname = $locationinfo->hos_name; 
        	        }
        	        else
        	        {
        	            $advise='';
        	            $hosname='';
        	        }
        	        
        	        
        	         
        	        
        	        
        	        $data.='<tr>
        	                    <td>'.$i++.'</td>
        	                    <td>'.$show->memeber_name.'</td>
        	                    <td>'.$show->age.'</td>
        	                    <td>'.$gname.'</td>
        	                    <td>'.$show->mobile_no.'</td>
        	                    <td>'.$relation.'</td>
        	                    <td>'.$show->date_of_exposure.'</td>
        	                    <td>'.$show->date_of_observation.'</td>
        	                    <td>'.$show->symptoms.'</td>
        	                    <td>'.$advise.'</td>
        	                    <td>'.$hosname.'</td>
        	                    <td><button type="button" class="btn btn-danger" onclick="delrec2('.$show->add_id.')">Delete</button></td>
        	                </tr>';
        	    }
        	    echo $data;
        	}
	        
	         public function high_risk_grid()
    	    {
            	$data['result']= $this->db->select('*')->where('tpr.deleted_DT',NULL)->join('mst_guard msg','msg.id = tpr.patient_id')->where('tpr.risk_type',1)->get('tbl_patient_risk tpr')->result();
    	        $this->load->view('admin/high_risk_grid',$data);
    	    }
	    
	    
	        public function deleterisk()
	        {
	            $id = $this->input->post('id');
	            $data = array("deleted_SI"=>$this->session->userdata('id'),"deleted_by"=>$this->session->userdata('username'),"deleted_DT"=>date('Y-m-d H:i:s'));
	            $this->db->where('add_id',$id)->update('tbl_risk_addmore',$data);
	        }
	        
	        public function deleteupdate()
	        {
	            $id = $this->input->post('id');
	            $data = array("deleted_SI"=>$this->session->userdata('id'),"deleted_by"=>$this->session->userdata('username'),"deleted_DT"=>date('Y-m-d H:i:s'));
	            $this->db->where('add_id',$id)->update('tbl_risk_addmore',$data);
	        }
	        
	        
	 
            public function deleteprevious()
            {
                $hiddenid = $this->input->post('hiddenid');
	            $data = array("deleted_SI"=>$this->session->userdata('id'),"deleted_by"=>$this->session->userdata('username'),"deleted_DT"=>date('Y-m-d H:i:s'));
	            $this->db->where('save_staus',0)->where('uniq_id',$hiddenid)->update('tbl_risk_addmore',$data);
            }
            
            
             public function low_risk_grid()
    	    {
            	$data['result']= $this->Risk_Model->low_risk_grid();
    	        $this->load->view('admin/low_risk_grid',$data);
    	    }
    	    
    	    
    	    public function newlowrisk()
        	{
        	        $query=$this->db->order_by('risk_id', 'DESC')->limit('1')->get('tbl_patient_risk')->row();
        	        @$pqidstring = explode('RSK', $query->risk_uniq);
        			@$pqid = array($pqidstring[1], 1);
        			$pqid = array_sum($pqid);
        			$pqidlength = strlen($pqid);
        			if($pqidlength == 1)
        			{
        				$uniqidd = '000'.$pqid;
        			}
        			else if($pqidlength == 2)
        			{
        				$uniqidd = '00'.$pqid;
        			}
        			else if($pqidlength == 3)
        			{
        				$uniqidd = '0'.$pqid;
        			}
        			else
        			{
        				$uniqidd = $pqid;
        			}
        			$data['uniq_id']='RSK'.$uniqidd;
        			$data['guard_arr']=$this->Duty_Model->get_patient();
        			$this->load->view('admin/new_low_risk',$data);
        	}
        	
        	
        	public function savelowrisk()
        	{
        	                $hiddenid = $this->input->post('hiddenid');
                	        $guard_name = $this->input->post('guard_name');
                	        $membernm = $this->input->post('membernm');
                	        $age = $this->input->post('age');
                	        $gender= $this->input->post('gender');
                	        $mobno= $this->input->post('mobno');
                	        
                	        $address = $this->input->post('address');
                	        $placecontact = $this->input->post('placecontact');
                	        $threefeet = $this->input->post('threefeet');
                	        $duration = $this->input->post('duration');
                	        $advise = $this->input->post('advise');
                	        $newloc = $this->input->post('newloc');
 
                	       
                	        $data = array('save_staus'=>0,'uniq_id'=>$hiddenid,'advise_location'=>$newloc,'patient_id'=>$guard_name,'risk_type'=>2,'memeber_name'=>$membernm,'age'=>$age,'gender'=>$gender,'mobile_no'=>$mobno,'address'=>$address,'contact_place'=>$placecontact,'contact_feet'=>$threefeet,'duration'=>$duration,'advisal'=>$advise,
                	        "inserted_SI"=>$this->session->userdata('id'),"inserted_BY"=>$this->session->userdata('username'),"inserted_DT"=>date('Y-m-d H:i:s'));
                	        $this->db->insert('tbl_risk_addmore',$data);
        	}
        	
        	
        	public function savelowrisk2()
        	{
        	                $hiddenid = $this->input->post('hiddenid');
                	        $guard_name = $this->input->post('guard_name');
                	        $membernm = $this->input->post('membernm');
                	        $age = $this->input->post('age');
                	        $gender= $this->input->post('gender');
                	        $mobno= $this->input->post('mobno');
                	        
                	        $address = $this->input->post('address');
                	        $placecontact = $this->input->post('placecontact');
                	        $threefeet = $this->input->post('threefeet');
                	        $duration = $this->input->post('duration');
                	        $advise = $this->input->post('advise');
                	        $newloc = $this->input->post('newloc');
                	       
                	        $data = array('save_staus'=>1,'uniq_id'=>$hiddenid,'advise_location'=>$newloc,'patient_id'=>$guard_name,'risk_type'=>2,'memeber_name'=>$membernm,'age'=>$age,'gender'=>$gender,'mobile_no'=>$mobno,'address'=>$address,'contact_place'=>$placecontact,'contact_feet'=>$threefeet,'duration'=>$duration,'advisal'=>$advise,
                	        "inserted_SI"=>$this->session->userdata('id'),"inserted_BY"=>$this->session->userdata('username'),"inserted_DT"=>date('Y-m-d H:i:s'));
                	        $this->db->insert('tbl_risk_addmore',$data);
        	}
        	
        	
        	public function getlowriskdata()
        	{
        	    $hiddenid = $this->input->post('hiddenid');
        	    $disp = $this->db->select('*')->where('deleted_DT',NULL)->where('risk_type',2)->where('uniq_id',$hiddenid)->get('tbl_risk_addmore')->result();
        	    
        	    $data = '';
        	    $i=1;
        	    foreach($disp as $show)
        	    {
        	        if($show->gender==1)
        	        {
        	            $gname = 'Male';
        	        }
        	        else if($show->gender==2)
        	        {
        	            $gname = 'Female';
        	        }
        	        
        	        if($show->contact_feet==1)
        	        {
        	            $contactfeet = 'Yes';
        	        }
        	        else if($show->contact_feet==2)
        	        {
        	            $contactfeet = 'No';
        	        }
        	        
        	        if($show->duration==1)
        	        {
        	            $duration = 'More than 1 Hrs';
        	        }
        	        else if($show->duration==2)
        	        {
        	            $duration = 'Less than 1 Hrs';
        	        }else if($show->duration==3){
        	            
        	            $duration = 'Pass One Day';
        	        }
        	        
        	        if($show->advisal==1)
        	        {
        	            $advise = 'Hospital';
        	            $locationinfo = $this->db->select('*')->where('hos_id',$show->advise_location)->where('type',1)->get('mst_hospital')->row();
        	            $hosname = $locationinfo->hos_name;
        	            
        	        }
        	        else if($show->advisal==2)
        	        {
        	            $advise = 'Isolation';
        	            $locationinfo = $this->db->select('*')->where('hos_id',$show->advise_location)->where('type',2)->get('mst_hospital')->row();
        	            $hosname = $locationinfo->hos_name;
        	        }
        	        else if($show->advisal==3)
        	        {
        	            $advise = 'Government Quarantine';
        	            $locationinfo = $this->db->select('*')->where('hos_id',$show->advise_location)->where('type',2)->get('mst_hospital')->row();
        	            $hosname = $locationinfo->hos_name;
        	        }
        	        else
        	        {
        	            $advise='';
        	            $hosname='';
        	        }
        	        
        	        
        	        
        	        $data.='<tr>
        	                    <td>'.$i++.'</td>
        	                    <td>'.$show->memeber_name.'</td>
        	                    <td>'.$show->age.'</td>
        	                    <td>'.$gname.'</td>
        	                    <td>'.$show->mobile_no.'</td>
        	                    <td>'.$show->address.'</td>
        	                    <td>'.$show->contact_place.'</td>
        	                    <td>'.$contactfeet.'</td>
        	                    <td>'.$duration.'</td>
        	                    <td>'.$advise.'</td>
        	                    <td>'.$hosname.'</td>
        	                    <td><button type="button" class="btn btn-danger" onclick="delrec('.$show->add_id.')">Delete</button></td>
        	                </tr>';
        	    }
        	    echo $data;
        	}
        	
        	public function getlowriskdata2()
        	{
        	    $hiddenid = $this->input->post('hiddenid');
        	    $disp = $this->db->select('*')->where('deleted_DT',NULL)->where('save_staus',1)->where('risk_type',2)->where('uniq_id',$hiddenid)->get('tbl_risk_addmore')->result();
        	    
        	    $data = '';
        	    $i=1;
        	    foreach($disp as $show)
        	    {
        	        if($show->gender==1)
        	        {
        	            $gname = 'Male';
        	        }
        	        else if($show->gender==2)
        	        {
        	            $gname = 'Female';
        	        }
        	        
        	        if($show->contact_feet==1)
        	        {
        	            $contactfeet = 'Yes';
        	        }
        	        else if($show->contact_feet==2)
        	        {
        	            $contactfeet = 'No';
        	        }
        	        
        	        if($show->duration==1)
        	        {
        	            $duration = 'More than 1 Hrs';
        	        }
        	        else if($show->duration==2)
        	        {
        	            $duration = 'Less than 1 Hrs';
        	        }else if($show->duration==3){
        	            
        	            $duration = 'Pass One Day';
        	        }
        	        
        	        if($show->advisal==1)
        	        {
        	            $advise = 'Hospital';
        	            $locationinfo = $this->db->select('*')->where('hos_id',$show->advise_location)->where('type',1)->get('mst_hospital')->row();
        	            $hosname = $locationinfo->hos_name;
        	            
        	        }
        	        else if($show->advisal==2)
        	        {
        	            $advise = 'Isolation';
        	            $locationinfo = $this->db->select('*')->where('hos_id',$show->advise_location)->where('type',2)->get('mst_hospital')->row();
        	            $hosname = $locationinfo->hos_name;
        	        }
        	        else if($show->advisal==3)
        	        {
        	            $advise = 'Government Quarantine';
        	            $locationinfo = $this->db->select('*')->where('hos_id',$show->advise_location)->where('type',2)->get('mst_hospital')->row();
        	            $hosname = $locationinfo->hos_name;
        	        }
        	        else
        	        {
        	            $advise='';
        	            $hosname='';
        	        }
        	        
        	        
        	        $data.='<tr>
        	                    <td>'.$i++.'</td>
        	                    <td>'.$show->memeber_name.'</td>
        	                    <td>'.$show->age.'</td>
        	                    <td>'.$gname.'</td>
        	                    <td>'.$show->mobile_no.'</td>
        	                    <td>'.$show->address.'</td>
        	                    <td>'.$show->contact_place.'</td>
        	                    <td>'.$contactfeet.'</td>
        	                    <td>'.$duration.'</td>
        	                    <td>'.$advise.'</td>
        	                    <td>'.$hosname.'</td>
        	                    <td><button type="button" class="btn btn-danger" onclick="delrec2('.$show->add_id.')">Delete</button></td>
        	                </tr>';
        	    }
        	    echo $data;
        	}
        	
        	public function deletelowrisk()
	        {
	            $id = $this->input->post('id');
	            $data = array("deleted_SI"=>$this->session->userdata('id'),"deleted_by"=>$this->session->userdata('username'),"deleted_DT"=>date('Y-m-d H:i:s'));
	            $this->db->where('add_id',$id)->update('tbl_risk_addmore',$data);
	        }
	        
	        
	        public function save_lowrisk()	
            	{
            		$this->load->library('form_validation');
            		$this->form_validation->set_rules('guard_name', 'Patient Name', 'required');
            	
            		if ($this->form_validation->run() == FALSE)
            		{
            	         $query=$this->db->order_by('risk_id', 'DESC')->limit('1')->get('tbl_patient_risk')->row();
            	        @$pqidstring = explode('RSK', $query->risk_uniq);
            			@$pqid = array($pqidstring[1], 1);
            			$pqid = array_sum($pqid);
            			$pqidlength = strlen($pqid);
            			if($pqidlength == 1)
            			{
            				$uniqidd = '000'.$pqid;
            			}
            			else if($pqidlength == 2)
            			{
            				$uniqidd = '00'.$pqid;
            			}
            			else if($pqidlength == 3)
            			{
            				$uniqidd = '0'.$pqid;
            			}
            			else
            			{
            				$uniqidd = $pqid;
            			}
            			$data['uniq_id']='RSK'.$uniqidd;
            			$data['guard_arr']=$this->Duty_Model->get_patient();
            			$this->load->view('admin/new_low_risk',$data);
            		}
            		else
            		{
            		        $uniqid = $this->input->post('hiddenid');
            		        $patientid = $this->input->post('guard_name');
            		       
            		       
            		        $check = $this->db->where('uniq_id',$uniqid)->where('save_staus',0)->where('deleted_DT',NULL)->get('tbl_risk_addmore')->result();
            		        
            		        if(count($check) > 0)
            		        {
                		        $data = array("risk_uniq"=>$uniqid,"patient_id"=>$patientid,"risk_type"=>2,"inserted_SI"=>$this->session->userdata('id'),"inserted_BY"=>$this->session->userdata('username'),"inserted_DT"=>date('Y-m-d H:i:s'));
                    	        $this->db->insert('tbl_patient_risk',$data);
                    	        $data2 = array('save_staus'=>1);
                    	        $this->db->where('uniq_id',$uniqid)->where('save_staus',0)->update('tbl_risk_addmore',$data2);
                    	        $this->session->set_flashdata(array("success"=>1));
    		                    redirect("Admin/low_risk_grid"); 
                    	        
            		        }
            		        else
            		        {
            		                    $query=$this->db->order_by('risk_id', 'DESC')->limit('1')->get('tbl_patient_risk')->row();
                            	        @$pqidstring = explode('RSK', $query->risk_uniq);
                            			@$pqid = array($pqidstring[1], 1);
                            			$pqid = array_sum($pqid);
                            			$pqidlength = strlen($pqid);
                            			if($pqidlength == 1)
                            			{
                            				$uniqidd = '000'.$pqid;
                            			}
                            			else if($pqidlength == 2)
                            			{
                            				$uniqidd = '00'.$pqid;
                            			}
                            			else if($pqidlength == 3)
                            			{
                            				$uniqidd = '0'.$pqid;
                            			}
                            			else
                            			{
                            				$uniqidd = $pqid;
                            			}
                            			$data['uniq_id']='RSK'.$uniqidd;
                            			$data['guard_arr']=$this->Duty_Model->get_patient();
                            			$data['errorinfo']= 'Information Not Added';
                            			$this->load->view('admin/new_low_risk',$data);
            			
            		        }
            		}   
            	}
            	
            	public function delete_lowrisk($id){
            	        $data=array("deleted_SI"=>$this->session->userdata('id'),
                                                "deleted_by"=>$this->session->userdata('username'),
                                                "deleted_DT"=>date('Y-m-d H:i:s'));
                        $c=$this->db->where('risk_id',$id)->update('tbl_patient_risk',$data);
                    	$this->session->set_flashdata(array("dsuccess"=>1));
            			redirect("Admin/low_risk_grid"); 
            	}
            	
            	public function updatelowrisk($id)
        	    {
                    $data['info'] = $this->db->select('*')->where('risk_id',$id)->get('tbl_patient_risk')->row();    	    
        			$data['guard_arr']=$this->Duty_Model->get_patient();
        			$this->load->view('admin/new_low_risk',$data);
        	    }
        	    
        	    
        	    public function update_lowrisk($id)	
            	{
            		$this->load->library('form_validation');
            		$this->form_validation->set_rules('guard_name', 'Patient Name', 'required');
            	
            		if ($this->form_validation->run() == FALSE)
            		{
            		    $data['info'] = $this->db->select('*')->where('risk_id',$id)->get('tbl_patient_risk')->row();    	    
        			    $data['guard_arr']=$this->Duty_Model->get_patient();
        			    $this->load->view('admin/new_low_risk',$data);
            		}
            		else
            		{
            		        $uniqid = $this->input->post('hiddenid2');
            		        $patientid = $this->input->post('guard_name');
            		        
            		        
            		        $check = $this->db->where('uniq_id',$uniqid)->where('save_staus',1)->where('deleted_DT',NULL)->get('tbl_risk_addmore')->result();
            		        
            		        if(count($check) > 0)
            		        {
            		             $data = array("modify_SI"=>$this->session->userdata('id'),"modify_BY"=>$this->session->userdata('username'),"modify_DT"=>date('Y-m-d H:i:s'));
                	             $this->db->where('risk_id',$id)->update('tbl_patient_risk',$data);
                	        
                	             $data2 = array('save_staus'=>1);
                	             $this->db->where('patient_id',$id)->where('uniq_id',$uniqid)->where('save_staus',0)->update('tbl_risk_addmore',$data2);
                	             $this->session->set_flashdata(array("usuccess"=>1));
		                         redirect("Admin/low_risk_grid");     
            		        }
            		        else
            		        {
            		            $data['info'] = $this->db->select('*')->where('risk_id',$id)->get('tbl_patient_risk')->row();    	    
        			            $data['guard_arr']=$this->Duty_Model->get_patient();
        			            $data['errorinfo']= 'Information Not Added';
        			            $this->load->view('admin/new_low_risk',$data);
            		        }
            		        
                	        
                	        
            		}   
            	}
            
            
            public function positive_case_register()
             {  
                 $data['low_risk'] = $this->db->select('*')->where('risk_type',2)->where('save_staus',1)->where('deleted_DT',NULL)->get('tbl_risk_addmore')->result();
                 $data['high_risk'] = $this->db->select('*')->where('risk_type',1)->where('save_staus',1)->where('deleted_DT',NULL)->get('tbl_risk_addmore')->result();
                 $data['health'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('tbl_health_center')->result();
                 $data['labs'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('mst_labs')->result();
                 $data['hos_list'] = $this->db->select('*')->where('type',1)->where('Deleted_DT',NULL)->get('mst_hospital')->result();
                 $data['guard_arr'] = $this->db->select('*')->where('patient_status',1)->where('Deleted_DT',NULL)->get('mst_guard')->result();
                 $this->load->view('admin/positive_case_register',$data);
             }
             
            	
             public function positive_patient()
             {  
                 $data['health'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('tbl_health_center')->result();
                 $data['labs'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('mst_labs')->result();
                 $data['highrisk'] = $this->db->select('*')->where('save_staus',1)->where('risk_type',1)->where('deleted_DT',NULL)->get('tbl_risk_addmore')->result();
                 $this->load->view('admin/add_positive_patient',$data);
             }
             
             
             public function insert_patient()
             {
                 
            	    $this->load->library('form_validation');
            	//	$this->form_validation->set_rules('patient_name', 'Patient Name', 'required');
            		$this->form_validation->set_rules('age', 'Age', 'required');
            		$this->form_validation->set_rules('gender', 'Gender', 'required');
            	//	$this->form_validation->set_rules('address', 'Address', 'required');
            	//	$this->form_validation->set_rules('healthcenter', 'Health Center', 'required');
            	//	$this->form_validation->set_rules('labs', 'Labs', 'required');
            		
                    if ($this->form_validation->run() == FALSE)
                    {
                        $data['health'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('tbl_health_center')->result();
                        $data['labs'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('mst_labs')->result();
                        $this->load->view('admin/add_positive_patient',$data);
                    }
                    else
                    {
                         if ($_POST['guard_name']!='')
                         {
                            $rec = $this->db->select('*')->where('add_id',$_POST['guard_name'])->get('tbl_risk_addmore')->row();
                            $parentpatient = $rec->patient_id;
                            $patientname = $rec->memeber_name;
                         }
                         else
                         {
                            $parentpatient= ''; 
                            $patientname = $this->input->post('patient_name');    
                         }
            	    	 $age = $this->input->post('age');
            	    	 $gender = $this->input->post('gender');
            	    	 $address = $this->input->post('address');
            	    	 $healthcenter = $this->input->post('healthcenter');
            	    	 $prabhagid = $this->input->post('prabhagid');
            	    	 $lab_id = $this->input->post('labs');
            	    	 
            	    	 $patienttype = $this->input->post('patienttype');
            	    	 $mobile = $this->input->post('mobile');
            	    	 
            	    	 $data = array("name"=>$patientname,"contact"=>$mobile,"parent_patient"=>$parentpatient,"prelimanry_type"=>$patienttype,"age"=>$age,"gender"=>$gender,"lab_id"=>$lab_id,"address"=>$address,"prabhag_id"=>$prabhagid,"Health_center"=>$healthcenter,"patient_status"=>1,"status"=>"Active",
            		        "inserted_SI"=>$this->session->userdata('id'),"inserted_by"=>$this->session->userdata('username'),"inserted_DT"=>date('Y-m-d H:i:s'));
                	        $this->db->insert('mst_guard',$data);
                	    
                	    
            		    $this->session->set_flashdata(array("success"=>1));
            		    redirect("Admin/positive_patient"); 
                    }
             }
             
             
             // start hospital summary
             public function hospital_summary_grid()
             {
                 $data['getdata'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('tbl_hospital_summery')->result();
                 $this->load->view('admin/hospital_summary_grid',$data);
             }
             
             public function add_summary()
             {
                 $data['hos_list'] = $this->db->select('*')->where('type',1)->where('Deleted_DT',NULL)->get('mst_hospital')->result();
                 $this->load->view('admin/add_hospital_summary',$data);
             }
             
             public function edit_hospitalsummary($id)
             {
                 $data['hos_list'] = $this->db->select('*')->where('Deleted_DT',NULL)->where('type',1)->get('mst_hospital')->result();
                 $data['info'] = $this->db->select('*')->where('summery_id',$id)->where('Deleted_DT',NULL)->get('tbl_hospital_summery')->row();
                 $this->load->view('admin/add_hospital_summary',$data);
             }
             
             
             public function save_hospital_summary()	
             {
                    $checkhos = $this->input->post('transfer');
            		$this->load->library('form_validation');
            		$this->form_validation->set_rules('admitted', 'Patient Admitted', 'required');
            	    $this->form_validation->set_rules('confirmcase', 'Covid Confirm Cases Admitted Today', 'required');
            	    $this->form_validation->set_rules('samplesent', 'No Of Sample Sent', 'required');
            	    $this->form_validation->set_rules('reportreceive', 'No Of Report Received', 'required');
            	    
            	    $this->form_validation->set_rules('awaited', 'No Of Negative Awaited', 'required');
            	    $this->form_validation->set_rules('transfer', 'Transfer To Other Hospital', 'required');
            	    $this->form_validation->set_rules('discharge', 'discharge', 'required');
            	    $this->form_validation->set_rules('death', 'death', 'required');
            	    
            	     if($checkhos==1)
            	    {
            	        $this->form_validation->set_rules('newloc', 'Hospital', 'required');
            	    }
            	    
            		if ($this->form_validation->run() == FALSE)
            		{
            		    $data['hos_list'] = $this->db->select('*')->where('Deleted_DT',NULL)->where('type',1)->get('mst_hospital')->result();
            	      	$this->load->view('admin/add_hospital_summary',$data);
            		}
            		else
            		{
            		        $admitted = $this->input->post('admitted');
            		        $admittoday = $this->input->post('admittoday');
            		        $confirmcase = $this->input->post('confirmcase');
            		        
            		        $samplesent = $this->input->post('samplesent');
            		        $reportreceive = $this->input->post('reportreceive');
            		        $awaited = $this->input->post('awaited');
            		        $transfer = $this->input->post('transfer');
            		        $newloc = $this->input->post('newloc');
            		        $discharge = $this->input->post('discharge');
            		        $death = $this->input->post('death');
            		       
            		        $data = array("yesterday_admitted"=>$admitted,"suspect_admit"=>$admittoday,"confirm_case"=>$confirmcase,"sent_sample"=>$samplesent,"report_receive"=>$reportreceive,"nagative_await"=>$awaited,
            		        "tansfer_hospital"=>$transfer,"hos_name"=>$newloc,"no_discharge"=>$discharge,"no_death"=>$death,
            		        "inserted_SI"=>$this->session->userdata('id'),"Inserted_BY"=>$this->session->userdata('username'),"inserted_DT"=>date('Y-m-d H:i:s'));
                	        $this->db->insert('tbl_hospital_summery',$data);
                	      
                	        $this->session->set_flashdata(array("success"=>1));
		                    redirect("Admin/hospital_summary_grid"); 
                	        
            		  
            		}   
            	}
                
                public function update_hospital_summary($id)	
                {
                    $checkhos = $this->input->post('transfer');
            		$this->load->library('form_validation');
            		$this->form_validation->set_rules('admitted', 'Patient Admitted', 'required');
            	    $this->form_validation->set_rules('confirmcase', 'Covid Confirm Cases Admitted Today', 'required');
            	    $this->form_validation->set_rules('samplesent', 'No Of Sample Sent', 'required');
            	    $this->form_validation->set_rules('reportreceive', 'No Of Report Received', 'required');
            	    
            	    $this->form_validation->set_rules('awaited', 'No Of Negative Awaited', 'required');
            	    $this->form_validation->set_rules('transfer', 'Transfer To Other Hospital', 'required');
            	    $this->form_validation->set_rules('discharge', 'discharge', 'required');
            	    $this->form_validation->set_rules('death', 'death', 'required');
            	    
            	    if($checkhos==1)
            	    {
            	        $this->form_validation->set_rules('newloc', 'Hospital', 'required');
            	    }
            		if ($this->form_validation->run() == FALSE)
            		{
                         $data['hos_list'] = $this->db->select('*')->where('Deleted_DT',NULL)->where('type',1)->get('mst_hospital')->result();
                         $data['info'] = $this->db->select('*')->where('summery_id',$id)->where('Deleted_DT',NULL)->get('tbl_hospital_summery')->row();
                         $this->load->view('admin/add_hospital_summary',$data);
            		}
            		else
            		{
            		        $admitted = $this->input->post('admitted');
            		        $admittoday = $this->input->post('admittoday');
            		        $confirmcase = $this->input->post('confirmcase');
            		        
            		        $samplesent = $this->input->post('samplesent');
            		        $reportreceive = $this->input->post('reportreceive');
            		        $awaited = $this->input->post('awaited');
            		        $transfer = $this->input->post('transfer');
            		        $newloc = $this->input->post('newloc');
            		        $discharge = $this->input->post('discharge');
            		        $death = $this->input->post('death');
            		       
            		        $data = array("yesterday_admitted"=>$admitted,"suspect_admit"=>$admittoday,"confirm_case"=>$confirmcase,"sent_sample"=>$samplesent,"report_receive"=>$reportreceive,"nagative_await"=>$awaited,
            		        "tansfer_hospital"=>$transfer,"hos_name"=>$newloc,"no_discharge"=>$discharge,"no_death"=>$death,
            		        "Modify_SI"=>$this->session->userdata('id'),"Modify_BY"=>$this->session->userdata('username'),"Modify_DT"=>date('Y-m-d H:i:s'));
                	        $this->db->where('summery_id',$id)->update('tbl_hospital_summery',$data);
                	      
                	        $this->session->set_flashdata(array("usuccess"=>1));
		                    redirect("Admin/hospital_summary_grid"); 
                	        
            		  
            		}   
            	}
            	
            	public function delethospitalsummary($id)
            	{
            		
            			$data=array(
            		            "Deleted_SI"=>$this->session->userdata('id'),
            					"Deleted_BY"=>$this->session->userdata('username'),
            					"Deleted_DT"=>date('Y-m-d H:s:i'));
            		$this->db->where('summery_id',$id)->update('tbl_hospital_summery',$data);
            		$this->session->set_flashdata(array("dsuccess"=>1));
            		redirect('Admin/hospital_summary_grid');
            		
            	}
            // end hospital summary
            	
             // start containment  form 
             public function containment_grid()
             {
                 $data['getdata'] = $this->db->select('tbc.address,tbc.officer_name,tbc.population,tbc.teams,tbc.daily_visit,tbc.total_supervisor,tbc.total_hospital,tbc.cont_id,msg.name')->join('mst_guard msg','msg.id=tbc.patient_name','left')->order_by('tbc.cont_id','desc')->where('tbc.Deleted_DT',NULL)->get('tbl_containment tbc')->result();
                 $this->load->view('admin/containment_grid',$data);
             }
             
             public function new_containment()
             {
                 $data['guard_arr'] = $this->Duty_Model->get_positive_patient();
                 $this->load->view('admin/new_containment',$data);
             }
             
             public function edit_containment($id)
             {
                 $data['guard_arr'] = $this->Duty_Model->get_positive_patient();
                 $data['info'] = $this->db->select('*')->where('cont_id',$id)->where('Deleted_DT',NULL)->get('tbl_containment')->row();
                 $this->load->view('admin/new_containment',$data);
             }
             
             public function save_containment()	
             {
                   
            		$this->load->library('form_validation');
            		$this->form_validation->set_rules('guard_name', 'Patient Name', 'required');
            	    $this->form_validation->set_rules('population', 'Population', 'required');
            	    $this->form_validation->set_rules('teams', 'Teams', 'required');
            	    $this->form_validation->set_rules('address', 'Address', 'required');
            	    
            	    $this->form_validation->set_rules('supervisor', 'Supervisor', 'required');
            	    $this->form_validation->set_rules('totalvisit', 'Total Visit', 'required');
            	    $this->form_validation->set_rules('totalhos', 'Total Hospital', 'required');
            	    $this->form_validation->set_rules('nodaloff', 'Nodal Officer', 'required');
            	    
            	   
            		if ($this->form_validation->run() == FALSE)
            		{
            		    $data['guard_arr'] = $this->Duty_Model->get_positive_patient();
            	      	$this->load->view('admin/new_containment',$data);
            		}
            		else
            		{
            		        $guard_name = $this->input->post('guard_name');
            		        $population = $this->input->post('population');
            		        $teams = $this->input->post('teams');
            		        
            		        $address = $this->input->post('address');
            		        $supervisor = $this->input->post('supervisor');
            		        $totalvisit = $this->input->post('totalvisit');
            		        $totalhos = $this->input->post('totalhos');
            		        $nodaloff = $this->input->post('nodaloff');
            		        
            		        
            		        $data = array("patient_name"=>$guard_name,"population"=>$population,"teams"=>$teams,"daily_visit"=>$totalvisit,"total_supervisor"=>$supervisor,"total_hospital"=>$totalhos,
            		        "officer_name"=>$nodaloff,"address"=>$address,
            		        "inserted_SI"=>$this->session->userdata('id'),"Inserted_BY"=>$this->session->userdata('username'),"inserted_DT"=>date('Y-m-d H:i:s'));
                	        $this->db->insert('tbl_containment',$data);
                	      
                	        $this->session->set_flashdata(array("success"=>1));
		                    redirect("Admin/containment_grid"); 
                	        
            		  
            		}   
            	}
                
                
                
             public function update_containment($id)	
             {
                   
            		$this->load->library('form_validation');
            		$this->form_validation->set_rules('guard_name', 'Patient Name', 'required');
            	    $this->form_validation->set_rules('population', 'Population', 'required');
            	    $this->form_validation->set_rules('teams', 'Teams', 'required');
            	    $this->form_validation->set_rules('address', 'Address', 'required');
            	    
            	    $this->form_validation->set_rules('supervisor', 'Supervisor', 'required');
            	    $this->form_validation->set_rules('totalvisit', 'Total Visit', 'required');
            	    $this->form_validation->set_rules('totalhos', 'Total Hospital', 'required');
            	    $this->form_validation->set_rules('nodaloff', 'Nodal Officer', 'required');
            	    
            	   
            		if ($this->form_validation->run() == FALSE)
            		{
            		    $data['guard_arr'] = $this->Duty_Model->get_positive_patient();
                        $data['info'] = $this->db->select('*')->where('cont_id',$id)->where('Deleted_DT',NULL)->get('tbl_containment')->row();
                        $this->load->view('admin/new_containment',$data);
            		}
            		else
            		{
            		        $guard_name = $this->input->post('guard_name');
            		        $population = $this->input->post('population');
            		        $teams = $this->input->post('teams');
            		        
            		        $address = $this->input->post('address');
            		        $supervisor = $this->input->post('supervisor');
            		        $totalvisit = $this->input->post('totalvisit');
            		        $totalhos = $this->input->post('totalhos');
            		        $nodaloff = $this->input->post('nodaloff');
            		        
            		        
            		        $data = array("patient_name"=>$guard_name,"population"=>$population,"teams"=>$teams,"daily_visit"=>$totalvisit,"total_supervisor"=>$supervisor,"total_hospital"=>$totalhos,
            		        "officer_name"=>$nodaloff,"address"=>$address,
            		        "Modify_SI"=>$this->session->userdata('id'),"Modify_BY"=>$this->session->userdata('username'),"Modify_DT"=>date('Y-m-d H:i:s'));
                	        $this->db->where('cont_id',$id)->update('tbl_containment',$data);
                	      
                	        $this->session->set_flashdata(array("usuccess"=>1));
		                    redirect("Admin/containment_grid"); 
                	        
            		  
            		}   
            	}
            
                public function deletecontainment($id)
            	{
            		
            			$data=array(
            		            "Deleted_SI"=>$this->session->userdata('id'),
            					"Deleted_BY"=>$this->session->userdata('username'),
            					"Deleted_DT"=>date('Y-m-d H:s:i'));
            		$this->db->where('cont_id',$id)->update('tbl_containment',$data);
            		$this->session->set_flashdata(array("dsuccess"=>1));
            		redirect('Admin/containment_grid');
            		
            	}
             // end containment form
             
             
            // start containment survey
            
             public function containment_survey_grid()
             {
                 $data['getdata'] = $this->db->select('*')->join('mst_guard msg','msg.id=tbc.patient_id','left')->where('tbc.Deleted_DT',NULL)->get('tbl_containment_survey tbc')->result();
                 $this->load->view('admin/containment_survey_grid',$data);
             }	
             
              public function new_survey_containment()
             {
                 $data['guard_arr'] = $this->Duty_Model->get_positive_patient();
                 $this->load->view('admin/new_contanmet_survey',$data);
             }
             
             public function edit_containment_survey($id)
             {
                 $data['guard_arr'] = $this->Duty_Model->get_positive_patient();
                 $data['info'] = $this->db->select('*')->where('con_sur_id',$id)->where('Deleted_DT',NULL)->get('tbl_containment_survey')->row();
                 $this->load->view('admin/new_contanmet_survey',$data);
             }
            	
            
             public function save_survey_containment()	
             {
                   
            		$this->load->library('form_validation');
            		$this->form_validation->set_rules('guard_name', 'Patient Name', 'required');
            	    $this->form_validation->set_rules('dailycase', 'Daily Positive Cases', 'required');
            	    $this->form_validation->set_rules('progressive', 'Daily Progressive Cases', 'required');
            	    $this->form_validation->set_rules('address', 'Address', 'required');
            	    
            	    $this->form_validation->set_rules('teamdeploy', 'No Of Team Deploy', 'required');
            	    $this->form_validation->set_rules('housecover', 'House Covered', 'required');
            	    $this->form_validation->set_rules('popcover', 'Population Covered', 'required');
            	    $this->form_validation->set_rules('symptoms', 'No of Symptoms suspects', 'required');
            	    
            	    
            	    $this->form_validation->set_rules('moexam', 'No Of Patient Exam By MO', 'required');
            	    $this->form_validation->set_rules('ilicount', 'Dignosis of ILI', 'required');
            	    $this->form_validation->set_rules('saricount', 'Dignosis of SARI', 'required');
            	    $this->form_validation->set_rules('othercount', 'Dignosis of Other', 'required');
            	    
            	    $this->form_validation->set_rules('molevel', 'No Of Patient Treat at MO Level', 'required');
            	    $this->form_validation->set_rules('investigation', 'Patient Refered BY MO Investigation', 'required');
            	    $this->form_validation->set_rules('positive', 'Positive Patient found', 'required');
            	    $this->form_validation->set_rules('remark', 'Remark', 'required');
            	    
            	   
            		if ($this->form_validation->run() == FALSE)
            		{
            		     $data['guard_arr'] = $this->Duty_Model->get_positive_patient();
                         $this->load->view('admin/new_contanmet_survey',$data);
            		}
            		else
            		{
            		        $guard_name = $this->input->post('guard_name');
            		        $dailycase = $this->input->post('dailycase');
            		        $progressive = $this->input->post('progressive');
            		        
            		        $address = $this->input->post('address');
            		        
            		        $teamdeploy = $this->input->post('teamdeploy');
            		        $housecover = $this->input->post('housecover');
            		        $popcover = $this->input->post('popcover');
            		        $symptoms = $this->input->post('symptoms');
            		        
            		        $moexam = $this->input->post('moexam');
            		        $ilicount = $this->input->post('ilicount');
            		        $saricount = $this->input->post('saricount');
            		        $othercount = $this->input->post('othercount');
            		        
            		        $molevel = $this->input->post('molevel');
            		        $investigation = $this->input->post('investigation');
            		        $positive = $this->input->post('positive');
            		        $remark = $this->input->post('remark');
            		        
            		        
            		        $data = array("patient_id"=>$guard_name,
            		        "daily_case"=>$dailycase,"progressive_case"=>$progressive,"area"=>$address,"team_deploy"=>$teamdeploy,"house_coverd"=>$housecover,"population_covered"=>$popcover,"sus_symptomps"=>$symptoms,"exam_by_mo"=>$moexam,"ili_count"=>$ilicount,"sari_count"=>$saricount,"other_count"=>$othercount,
            		        "mo_level_treated"=>$molevel,"mo_investigation"=>$investigation,"found_patient"=>$positive,"remark"=>$remark,
            		        "inserted_SI"=>$this->session->userdata('id'),"Inserted_BY"=>$this->session->userdata('username'),"inserted_DT"=>date('Y-m-d H:i:s'));
                	        $this->db->insert('tbl_containment_survey',$data);
                	      
                	        $this->session->set_flashdata(array("success"=>1));
		                    redirect("Admin/containment_survey_grid"); 
                	        
            		  
            		}   
            	}
            	
            	
            	 public function update_survey_containment($id)	
             {
                   
            		$this->load->library('form_validation');
            		$this->form_validation->set_rules('guard_name', 'Patient Name', 'required');
            	    $this->form_validation->set_rules('dailycase', 'Daily Positive Cases', 'required');
            	    $this->form_validation->set_rules('progressive', 'Daily Progressive Cases', 'required');
            	    $this->form_validation->set_rules('address', 'Address', 'required');
            	    
            	    $this->form_validation->set_rules('teamdeploy', 'No Of Team Deploy', 'required');
            	    $this->form_validation->set_rules('housecover', 'House Covered', 'required');
            	    $this->form_validation->set_rules('popcover', 'Population Covered', 'required');
            	    $this->form_validation->set_rules('symptoms', 'No of Symptoms suspects', 'required');
            	    
            	    
            	    $this->form_validation->set_rules('moexam', 'No Of Patient Exam By MO', 'required');
            	    $this->form_validation->set_rules('ilicount', 'Dignosis of ILI', 'required');
            	    $this->form_validation->set_rules('saricount', 'Dignosis of SARI', 'required');
            	    $this->form_validation->set_rules('othercount', 'Dignosis of Other', 'required');
            	    
            	    $this->form_validation->set_rules('molevel', 'No Of Patient Treat at MO Level', 'required');
            	    $this->form_validation->set_rules('investigation', 'Patient Refered BY MO Investigation', 'required');
            	    $this->form_validation->set_rules('positive', 'Positive Patient found', 'required');
            	    $this->form_validation->set_rules('remark', 'Remark', 'required');
            	    
            	   
            		if ($this->form_validation->run() == FALSE)
            		{
            		     $data['guard_arr'] = $this->Duty_Model->get_positive_patient();
                         $data['info'] = $this->db->select('*')->where('con_sur_id',$id)->where('Deleted_DT',NULL)->get('tbl_containment_survey')->row();
                         $this->load->view('admin/new_contanmet_survey',$data);
            		}
            		else
            		{
            		        $guard_name = $this->input->post('guard_name');
            		        $dailycase = $this->input->post('dailycase');
            		        $progressive = $this->input->post('progressive');
            		        
            		        $address = $this->input->post('address');
            		        
            		        $teamdeploy = $this->input->post('teamdeploy');
            		        $housecover = $this->input->post('housecover');
            		        $popcover = $this->input->post('popcover');
            		        $symptoms = $this->input->post('symptoms');
            		        
            		        $moexam = $this->input->post('moexam');
            		        $ilicount = $this->input->post('ilicount');
            		        $saricount = $this->input->post('saricount');
            		        $othercount = $this->input->post('othercount');
            		        
            		        $molevel = $this->input->post('molevel');
            		        $investigation = $this->input->post('investigation');
            		        $positive = $this->input->post('positive');
            		        $remark = $this->input->post('remark');
            		        
            		        
            		        $data = array("patient_id"=>$guard_name,
            		        "daily_case"=>$dailycase,"progressive_case"=>$progressive,"area"=>$address,"team_deploy"=>$teamdeploy,"house_coverd"=>$housecover,"population_covered"=>$popcover,"sus_symptomps"=>$symptoms,"exam_by_mo"=>$moexam,"ili_count"=>$ilicount,"sari_count"=>$saricount,"other_count"=>$othercount,
            		        "mo_level_treated"=>$molevel,"mo_investigation"=>$investigation,"found_patient"=>$positive,"remark"=>$remark,
            		        "Modify_SI"=>$this->session->userdata('id'),"Modify_BY"=>$this->session->userdata('username'),"Modify_DT"=>date('Y-m-d H:i:s'));
                	        $this->db->where('con_sur_id',$id)->update('tbl_containment_survey',$data);
                	      
                	        $this->session->set_flashdata(array("usuccess"=>1));
		                    redirect("Admin/containment_survey_grid"); 
                	        
            		  
            		}   
            	}
            	
            	
            	public function deletecontainmentsurvey($id)
            	{
            		
            			$data=array(
            		            "Deleted_SI"=>$this->session->userdata('id'),
            					"Deleted_BY"=>$this->session->userdata('username'),
            					"Deleted_DT"=>date('Y-m-d H:s:i'));
            		$this->db->where('con_sur_id',$id)->update('tbl_containment_survey',$data);
            		$this->session->set_flashdata(array("dsuccess"=>1));
            		redirect('Admin/containment_survey_grid');
            		
            	}
            	
                // end containment survey
             
              // opd center
              
              public function opd_center_grid()
             {
                 $data['getdata'] = $this->db->select('opc.contact_no,opc.opd_name,thc.center_name,tpc.prbhag_name,opc.opt_id')->join('tbl_health_center thc','thc.center_id=opc.health_center','left')->join('tbl_prabhag tpc','tpc.prabhag_id=opc.prabhag_id','left')->order_by('opc.opt_id','desc')->where('opc.Deleted_DT',NULL)->get('tbl_opd_center opc')->result();
                 $this->load->view('admin/opd_center_grid',$data);
             }	
             
             public function new_opd()
             {
                 $data['health'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('tbl_health_center')->result();
                 $this->load->view('admin/add_opd',$data);
             }	
             
             
             
             public function edit_opd($id)
             {
                 $data['health'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('tbl_health_center')->result();
                 $data['info'] = $this->db->select('*')->where('opt_id',$id)->where('Deleted_DT',NULL)->get('tbl_opd_center')->row();
                 $this->load->view('admin/add_opd',$data);
             }
             
             
             public function getprbhaginfo()
        	{
        	    $healthcenter = $this->input->post('healthcenter');
        	    
        	    $getinfo = $this->db->select('tpa.prbhag_name,tpa.prabhag_id')->join('tbl_prabhag tpa','tpa.prabhag_id = thc.prabhag_id')->where('thc.center_id',$healthcenter)->where('thc.deleted_DT',NULL)->get('tbl_health_center thc')->result();
          	    echo json_encode(array_shift($getinfo));
        	}
        	
        	 public function save_opd()	
             {
                   
            		$this->load->library('form_validation');
            		$this->form_validation->set_rules('opdname', 'OPD Name', 'required');
            	    $this->form_validation->set_rules('healthcenter', 'Health Center', 'required');
            	    $this->form_validation->set_rules('prabhagname', 'Prabhag Name', 'required');
            
            		if ($this->form_validation->run() == FALSE)
            		{
            		    $data['health'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('tbl_health_center')->result();
                        $this->load->view('admin/add_opd',$data);
            		}
            		else
            		{
            		        $opdname = $this->input->post('opdname');
            		        $health = $this->input->post('healthcenter');
            		        $prabhag = $this->input->post('prabhagid');
            		        $contact = $this->input->post('contactno');
            		        
            		        $data = array("opd_name"=>$opdname,"health_center"=>$health,"prabhag_id"=>$prabhag,"contact_no"=>$contact,
            		        "inserted_SI"=>$this->session->userdata('id'),"Inserted_BY"=>$this->session->userdata('username'),"inserted_DT"=>date('Y-m-d H:i:s'));
                	        $this->db->insert('tbl_opd_center',$data);
                	      
                	        $this->session->set_flashdata(array("success"=>1));
		                    redirect("Admin/opd_center_grid"); 
                	        
            		  
            		}   
            	}
            	
            	public function update_opd($id)
            	{
            	    
            		$this->load->library('form_validation');
            		$this->form_validation->set_rules('opdname', 'OPD Name', 'required');
            	    $this->form_validation->set_rules('healthcenter', 'Health Center', 'required');
            	    $this->form_validation->set_rules('prabhagname', 'Prabhag Name', 'required');
            
            		if ($this->form_validation->run() == FALSE)
            		{
            		     $data['health'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('tbl_health_center')->result();
                         $data['info'] = $this->db->select('*')->where('opt_id',$id)->where('Deleted_DT',NULL)->get('tbl_opd_center')->row();
                         $this->load->view('admin/add_opd',$data);
            		}
            		else
            		{
            		        $opdname = $this->input->post('opdname');
            		        $health = $this->input->post('healthcenter');
            		        $prabhag = $this->input->post('prabhagid');
            		        $contact = $this->input->post('contactno');
            		        
            		        $data = array("opd_name"=>$opdname,"health_center"=>$health,"prabhag_id"=>$prabhag,"contact_no"=>$contact,
            		        "inserted_SI"=>$this->session->userdata('id'),"Inserted_BY"=>$this->session->userdata('username'),"inserted_DT"=>date('Y-m-d H:i:s'));
                	        $this->db->where('opt_id',$id)->update('tbl_opd_center',$data);
                	      
                	        $this->session->set_flashdata(array("usuccess"=>1));
		                    redirect("Admin/opd_center_grid"); 
                	        
            		  
            		}
            	}
            	
            	public function deleteopd($id)
            	{
            		
            			$data=array(
            		            "Deleted_SI"=>$this->session->userdata('id'),
            					"Deleted_BY"=>$this->session->userdata('username'),
            					"Deleted_DT"=>date('Y-m-d H:s:i'));
            		$this->db->where('opt_id',$id)->update('tbl_opd_center',$data);
            		$this->session->set_flashdata(array("dsuccess"=>1));
            		redirect('Admin/opd_center_grid');
            		
            	}
                // end opd center
                
                 public function opd_summary_grid()
                 {
                     $data['getdata'] = $this->db->select('toc.opd_name as pname,ops.*')->join('tbl_opd_center toc','toc.opt_id=ops.opd_name','left')->order_by('ops.osummary_id','desc')->where('ops.Deleted_DT',NULL)->get('tbl_opd_summary ops')->result();
                     $this->load->view('admin/opd_summary_grid',$data);
                 }
                 
                 public function new_opd_summary()
                 {
                     $data['opd_arr'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('tbl_opd_center')->result();
                     $this->load->view('admin/new_opd_summary',$data);
                 }
                 
                 public function edit_opd_summary($id)
                 {
                     $data['opd_arr'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('tbl_opd_center')->result();
                     $data['info'] = $this->db->select('*')->where('osummary_id',$id)->where('Deleted_DT',NULL)->get('tbl_opd_summary')->row();
                     $this->load->view('admin/new_opd_summary',$data);
                 }
                 
                 public function save_opd_summary()	
                 {
                		$this->load->library('form_validation');
                		$this->form_validation->set_rules('opdname', 'OPD Name', 'required');
                	    $this->form_validation->set_rules('opdattendance', 'OPD Attendance', 'required');
                	    $this->form_validation->set_rules('symptom', 'Flu Like Symptoms', 'required');
                        
                        $this->form_validation->set_rules('covidtest', 'Refer for Covid Test', 'required');
                	    $this->form_validation->set_rules('homequorantine', 'Refer for Home Quorantine', 'required');
                	    $this->form_validation->set_rules('facility', 'Refer for Quorantine facility', 'required');
                
                
                		if ($this->form_validation->run() == FALSE)
                		{
                		    
                            $data['opd_arr'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('tbl_opd_center')->result();
                            $this->load->view('admin/new_opd_summary',$data);
                		}
                		else
                		{
                		        $opdname = $this->input->post('opdname');
                		        $opdattendance = $this->input->post('opdattendance');
                		        $symptom = $this->input->post('symptom');
                		        $covidtest = $this->input->post('covidtest');
                		        $homequorantine = $this->input->post('homequorantine');
                		        $facility = $this->input->post('facility');
                		        
                		        $data = array("opd_name"=>$opdname,"opd_attendance"=>$opdattendance,"flu_symptoms"=>$symptom,"refer_covid_test"=>$covidtest,"refer_home_quoran"=>$homequorantine,"refer_facility"=>$facility,
                		        "inserted_SI"=>$this->session->userdata('id'),"Inserted_BY"=>$this->session->userdata('username'),"inserted_DT"=>date('Y-m-d H:i:s'));
                    	        $this->db->insert('tbl_opd_summary',$data);
                    	      
                    	        $this->session->set_flashdata(array("success"=>1));
    		                    redirect("Admin/opd_summary_grid"); 
                    	        
                		  
                		}   
                	}
                	
                	
                 public function update_opd_summary($id)	
                 {
                		$this->load->library('form_validation');
                		$this->form_validation->set_rules('opdname', 'OPD Name', 'required');
                	    $this->form_validation->set_rules('opdattendance', 'OPD Attendance', 'required');
                	    $this->form_validation->set_rules('symptom', 'Flu Like Symptoms', 'required');
                        
                        $this->form_validation->set_rules('covidtest', 'Refer for Covid Test', 'required');
                	    $this->form_validation->set_rules('homequorantine', 'Refer for Home Quorantine', 'required');
                	    $this->form_validation->set_rules('facility', 'Refer for Quorantine facility', 'required');
                
                
                		if ($this->form_validation->run() == FALSE)
                		{
                		    
                                $data['opd_arr'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('tbl_opd_center')->result();
                                $data['info'] = $this->db->select('*')->where('osummary_id',$id)->where('Deleted_DT',NULL)->get('tbl_opd_summary')->row();
                                $this->load->view('admin/new_opd_summary',$data);
                		}
                		else
                		{
                		        $opdname = $this->input->post('opdname');
                		        $opdattendance = $this->input->post('opdattendance');
                		        $symptom = $this->input->post('symptom');
                		        $covidtest = $this->input->post('covidtest');
                		        $homequorantine = $this->input->post('homequorantine');
                		        $facility = $this->input->post('facility');
                		        
                		        $data = array("opd_name"=>$opdname,"opd_attendance"=>$opdattendance,"flu_symptoms"=>$symptom,"refer_covid_test"=>$covidtest,"refer_home_quoran"=>$homequorantine,"refer_facility"=>$facility,
                		        "Modify_SI"=>$this->session->userdata('id'),"Modify_BY"=>$this->session->userdata('username'),"Modify_DT"=>date('Y-m-d H:i:s'));
                    	        $this->db->where('osummary_id',$id)->update('tbl_opd_summary',$data);
                    	      
                    	        $this->session->set_flashdata(array("usuccess"=>1));
    		                    redirect("Admin/opd_summary_grid"); 
                    	        
                		  
                		}   
                	}
                	
                	
                	public function deleteopdsummary($id)
                	{
                			$data=array(
                		            "Deleted_SI"=>$this->session->userdata('id'),
                					"Deleted_BY"=>$this->session->userdata('username'),
                					"Deleted_DT"=>date('Y-m-d H:s:i'));
                		$this->db->where('osummary_id',$id)->update('tbl_opd_summary',$data);
                		$this->session->set_flashdata(array("dsuccess"=>1));
                		redirect('Admin/opd_summary_grid');
                		
                	}
                	
                	// end opd summary
                    
                    // Isolation / summary start 
                    
                    public function summary_iso_gov_grid()
                    {
                        $data['show'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('tbl_ccc_summary')->result();
                        $this->load->view('admin/ccc_grid',$data);
                    }
                    public function new_iso_summary()
                    {
                        $this->load->view('admin/new_iso_gov_summary');
                    }
                    
                    public function edit_iso_summary($id)
                    {
                        $gethospital = $this->db->select('*')->where('Deleted_DT',NULL)->where('ccc_id',$id)->get('tbl_ccc_summary')->row();
                        
                        if($gethospital->summary_type==1)
                        {
                            $sid = 2;
                        }
                        else if($gethospital->summary_type==2)
                        {
                            $sid = 3;
                        }
                        $data['hos_list'] = $this->db->where('type',$sid)->where('Deleted_DT',NULL)->get('mst_hospital')->result();
                        $data['info'] = $this->db->select('*')->where('Deleted_DT',NULL)->where('ccc_id',$id)->get('tbl_ccc_summary')->row();
                        $this->load->view('admin/new_iso_gov_summary',$data);
                    }
                    
                    
                 public function save_isolation_summary()	
                 {
                        $sumtype = $this->input->post('sumtype');
                		$this->load->library('form_validation');
                		$this->form_validation->set_rules('sumdate', 'Summary Date', 'required');
                	    $this->form_validation->set_rules('sumtype', 'Type', 'required');
                	    $this->form_validation->set_rules('newloc', 'Isolation Center', 'required');
                        
                        $this->form_validation->set_rules('suspect', 'Total Suspect till Yesterday', 'required');
                	    $this->form_validation->set_rules('newadmit', 'Total New Admission', 'required');
                	    $this->form_validation->set_rules('susadmit', 'No of Suspect Admitted', 'required');
                
                        
                        
                        $this->form_validation->set_rules('pvtswab', 'No Of Swabs Sent To PVT Labs', 'required');
                	    $this->form_validation->set_rules('govtswab', 'No Of Swabs Sent To GOVT Labs', 'required');
                	    $this->form_validation->set_rules('totalswab', 'Total No of Swabs sent', 'required');
                        
                        $this->form_validation->set_rules('quorantine', 'No Of Transfer to Quorantine', 'required');
                	    $this->form_validation->set_rules('hoquorantine', 'No Of Transfer to Home Quorantine', 'required');
                    
                        if($sumtype==1)
                        {
                                $this->form_validation->set_rules('positive', 'No Of Positive', 'required');
                	            $this->form_validation->set_rules('negative', 'No Of Negative', 'required');
                	            $this->form_validation->set_rules('transfercovid', 'Transfer to Covid Hospital', 'required');
                            
                        }
                        // else if($sumtype==2)
                        // {
                        //             $this->form_validation->set_rules('refertohos', 'No Of Patient Refer To Covid Hospital', 'required');
                	       //         $this->form_validation->set_rules('otherhos', 'No Of Patient Refer To Other Hospital', 'required');
                	       //         $this->form_validation->set_rules('discharge', 'Discharge After Completion Of Quorantine Period', 'required');
                    
                        // }
                
                		if ($this->form_validation->run() == FALSE)
                		{
                		    $this->load->view('admin/new_iso_gov_summary');
                		}
                		else
                		{
                		        $sumdate = $this->input->post('sumdate');
                		        $sumtype = $this->input->post('sumtype');
                		        $newloc = $this->input->post('newloc');
                		        $suspect = $this->input->post('suspect');
                		        $newadmit = $this->input->post('newadmit');
                		        $susadmit = $this->input->post('susadmit');
                		        
                		        $pvtswab = $this->input->post('pvtswab');
                		        $govtswab = $this->input->post('govtswab');
                		        $totalswab = $this->input->post('totalswab');
                		        $quorantine = $this->input->post('quorantine');
                		        $hoquorantine = $this->input->post('hoquorantine');
                		        
                		        $positive= $this->input->post('positive');
                		        $negative= $this->input->post('negative');
                		        $transfercovid = $this->input->post('transfercovid');
                		        $refertohos = $this->input->post('refertohos');
                		        $otherhos = $this->input->post('otherhos');
                		        $discharge = $this->input->post('discharge');
                		        
                		        
                		        $data = array("summary_date"=>$sumdate,
                		                      "summary_type"=>$sumtype,
                		                      "isolation_center"=>$newloc,
                		                      "total_suspect_found"=>$suspect,
                		                      "new_addmission"=>$newadmit,
                		                      "total_suspect_admit"=>$susadmit,
                		                      "sent_private_lab"=>$pvtswab,
                		                      "sent_gov_lab"=>$govtswab,
                		                      "total_swab"=>$totalswab,
                		                      "transfer_quorantine"=>$quorantine,
                		                      "transfer_hq"=>$hoquorantine,
                		                      
                		                      "total_positive"=>$positive,
                		                      "total_negative"=>$negative,
                		                      "transfer_hospital"=>$transfercovid,
                		                      "refer_covid"=>$refertohos,
                		                      "refer_other_hos"=>$otherhos,
                		                      "discharge_patient"=>$discharge,
                		                      
                		            
                		        "inserted_SI"=>$this->session->userdata('id'),"Inserted_BY"=>$this->session->userdata('username'),"inserted_DT"=>date('Y-m-d H:i:s'));
                    	        $this->db->insert('tbl_ccc_summary',$data);
                    	      
                    	        $this->session->set_flashdata(array("success"=>1));
    		                    redirect("Admin/summary_iso_gov_grid"); 
                    	        
                		  
                		}   
                	}
                	
                	
                	
                	public function update_isolation_sumary($id)	
                 {
                        $sumtype = $this->input->post('sumtype');
                		$this->load->library('form_validation');
                		$this->form_validation->set_rules('sumdate', 'Summary Date', 'required');
                	    $this->form_validation->set_rules('sumtype', 'Type', 'required');
                	    $this->form_validation->set_rules('newloc', 'Isolation Center', 'required');
                        
                        $this->form_validation->set_rules('suspect', 'Total Suspect till Yesterday', 'required');
                	    $this->form_validation->set_rules('newadmit', 'Total New Admission', 'required');
                	    $this->form_validation->set_rules('susadmit', 'No of Suspect Admitted', 'required');
                
                        
                        
                        $this->form_validation->set_rules('pvtswab', 'No Of Swabs Sent To PVT Labs', 'required');
                	    $this->form_validation->set_rules('govtswab', 'No Of Swabs Sent To GOVT Labs', 'required');
                	    $this->form_validation->set_rules('totalswab', 'Total No of Swabs sent', 'required');
                        
                        $this->form_validation->set_rules('quorantine', 'No Of Transfer to Quorantine', 'required');
                	    $this->form_validation->set_rules('hoquorantine', 'No Of Transfer to Home Quorantine', 'required');
                        
                        if($sumtype==1)
                        {
                                $this->form_validation->set_rules('positive', 'No Of Positive', 'required');
                	            $this->form_validation->set_rules('negativ', 'No Of Negative', 'required');
                	            $this->form_validation->set_rules('transfercovid', 'Transfer to Covid Hospital', 'required');
                            
                        }
                       // else if($sumtype==2)
                        // {
                        //             $this->form_validation->set_rules('refertohos', 'No Of Patient Refer To Covid Hospital', 'required');
                	       //         $this->form_validation->set_rules('otherhos', 'No Of Patient Refer To Other Hospital', 'required');
                	       //         $this->form_validation->set_rules('discharge', 'Discharge After Completion Of Quorantine Period', 'required');
                    
                        // }
                
                		if ($this->form_validation->run() == FALSE)
                		{
                		    $gethospital = $this->db->select('*')->where('Deleted_DT',NULL)->where('ccc_id',$id)->get('tbl_ccc_summary')->row();
                            
                            if($gethospital->summary_type==1)
                            {
                                $sid = 2;
                            }
                            else if($gethospital->summary_type==2)
                            {
                                $sid = 3;
                            }
                            $data['hos_list'] = $this->db->where('type',$sid)->where('Deleted_DT',NULL)->get('mst_hospital')->result();
                            
                            $data['info'] = $this->db->select('*')->where('Deleted_DT',NULL)->where('ccc_id',$id)->get('tbl_ccc_summary')->row();
                            $this->load->view('admin/new_iso_gov_summary',$data);
                		}
                		else
                		{
                		        $sumdate = $this->input->post('sumdate');
                		        $sumtype = $this->input->post('sumtype');
                		        $newloc = $this->input->post('newloc');
                		        $suspect = $this->input->post('suspect');
                		        $newadmit = $this->input->post('newadmit');
                		        $susadmit = $this->input->post('susadmit');
                		        
                		        $pvtswab = $this->input->post('pvtswab');
                		        $govtswab = $this->input->post('govtswab');
                		        $totalswab = $this->input->post('totalswab');
                		        $quorantine = $this->input->post('quorantine');
                		        $hoquorantine = $this->input->post('hoquorantine');
                		        
                		        $positive= $this->input->post('positive');
                		        $negative= $this->input->post('negative');
                		        $transfercovid = $this->input->post('transfercovid');
                		        $refertohos = $this->input->post('refertohos');
                		        $otherhos = $this->input->post('otherhos');
                		        $discharge = $this->input->post('discharge');
                		        
                		        
                		        $data = array("summary_date"=>$sumdate,
                		                      "summary_type"=>$sumtype,
                		                      "isolation_center"=>$newloc,
                		                      "total_suspect_found"=>$suspect,
                		                      "new_addmission"=>$newadmit,
                		                      "total_suspect_admit"=>$susadmit,
                		                      "sent_private_lab"=>$pvtswab,
                		                      "sent_gov_lab"=>$govtswab,
                		                      "total_swab"=>$totalswab,
                		                      "transfer_quorantine"=>$quorantine,
                		                      "transfer_hq"=>$hoquorantine,
                		                      
                		                      "total_positive"=>$positive,
                		                      "total_negative"=>$negative,
                		                      "transfer_hospital"=>$transfercovid,
                		                      "refer_covid"=>$refertohos,
                		                      "refer_other_hos"=>$otherhos,
                		                      "discharge_patient"=>$discharge,
                		                      
                		            
                		        "Modify_SI"=>$this->session->userdata('id'),"Modify_BY"=>$this->session->userdata('username'),"Modify_DT"=>date('Y-m-d H:i:s'));
                    	        $this->db->where('ccc_id',$id)->update('tbl_ccc_summary',$data);
                    	      
                    	        $this->session->set_flashdata(array("usuccess"=>1));
    		                    redirect("Admin/summary_iso_gov_grid"); 
                    	        
                		  
                		}   
                	}
                	
                	public function deleteisolationsummary($id)
                	{
                			$data=array(
                		            "Deleted_SI"=>$this->session->userdata('id'),
                					"Deleted_BY"=>$this->session->userdata('username'),
                					"Deleted_DT"=>date('Y-m-d H:s:i'));
                		$this->db->where('ccc_id',$id)->update('tbl_ccc_summary',$data);
                		$this->session->set_flashdata(array("dsuccess"=>1));
                		redirect('Admin/summary_iso_gov_grid');
                		
                	}
                    // end isolation / summary end
                    
                    
                 public function Health_center_grid()
                 {
                     $data['getdata'] = $this->db->select('toc.prbhag_name,ops.*')->join('tbl_prabhag toc','toc.prabhag_id=ops.prabhag_id','left')->order_by('ops.center_id','desc')->where('ops.Deleted_DT',NULL)->get('tbl_health_center ops')->result();
                     $this->load->view('admin/health_center_grid',$data);
                 }
                 
                public function new_health()
                {
                    $data['info'] = $this->db->select('*')->get('tbl_prabhag')->result();
                    $this->load->view('admin/new_health_center',$data);
                }
                
                public function edit_health($id)
                {
                    $data['getinfo'] = $this->db->select('*')->where('center_id',$id)->get('tbl_health_center')->row();
                    $data['info'] = $this->db->select('*')->get('tbl_prabhag')->result();
                    $this->load->view('admin/new_health_center',$data);
                }
                    
                    
                 public function save_health_center()	
                 {

                		$this->load->library('form_validation');
                		$this->form_validation->set_rules('prabhag', 'Prabhag Name', 'required');
                	    $this->form_validation->set_rules('healthcenter', 'Health Center Name', 'required');

                		if ($this->form_validation->run() == FALSE)
                		{
                		    $data['info'] = $this->db->select('*')->get('tbl_prabhag')->result();
                            $this->load->view('admin/new_health_center',$data);
                		}
                		else
                		{
                		        $prabhag = $this->input->post('prabhag');
                		        $center = $this->input->post('healthcenter');

                		        $data = array("prabhag_id"=>$prabhag,
                		                      "center_name"=>$center,
                		        "inserted_SI"=>$this->session->userdata('id'),"Inserted_BY"=>$this->session->userdata('username'),"inserted_DT"=>date('Y-m-d H:i:s'));
                    	        $this->db->insert('tbl_health_center',$data);
                    	      
                    	        $this->session->set_flashdata(array("success"=>1));
    		                    redirect("Admin/Health_center_grid"); 
                    	        
                		  
                		}   
              }
              
              
                  public function upate_health_center($id)	
                 {

                		$this->load->library('form_validation');
                		$this->form_validation->set_rules('prabhag', 'Prabhag Name', 'required');
                	    $this->form_validation->set_rules('healthcenter', 'Health Center Name', 'required');

                		if ($this->form_validation->run() == FALSE)
                		{
                		    $data['getinfo'] = $this->db->select('*')->where('center_id',$id)->get('tbl_health_center')->row();
                            $data['info'] = $this->db->select('*')->get('tbl_prabhag')->result();
                            $this->load->view('admin/new_health_center',$data);
                		}
                		else
                		{
                		        $prabhag = $this->input->post('prabhag');
                		        $center = $this->input->post('healthcenter');

                		        $data = array("prabhag_id"=>$prabhag,
                		                      "center_name"=>$center,
                		        "Modify_SI"=>$this->session->userdata('id'),"Modify_BY"=>$this->session->userdata('username'),"Modify_DT"=>date('Y-m-d H:i:s'));
                    	        $this->db->where('center_id',$id)->update('tbl_health_center',$data);
                    	      
                    	        $this->session->set_flashdata(array("usuccess"=>1));
    		                    redirect("Admin/Health_center_grid"); 
                    	        
                		  
                		}   
              }
              
              	public function deletecenter($id)
            	{
            			$data=array(
            		            "Deleted_SI"=>$this->session->userdata('id'),
            					"Deleted_BY"=>$this->session->userdata('username'),
            					"Deleted_DT"=>date('Y-m-d H:s:i'));
            		$this->db->where('center_id',$id)->update('tbl_health_center',$data);
            		$this->session->set_flashdata(array("dsuccess"=>1));
            		redirect('Admin/Health_center_grid');
            		
            	}
            	
            	 public function lab_grid()
                 {
                     $data['getdata'] = $this->db->select('*')->order_by('lab_id','desc')->where('Deleted_DT',NULL)->get('mst_labs')->result();
                     $this->load->view('admin/lab_grid',$data);
                 }
                 
                 public function add_lab()
                 {
                     $this->load->view('admin/add_lab');
                 }
                 
                 public function edit_labs($id)
                 {
                     $data['getdata'] = $this->db->select('*')->where('lab_id',$id)->where('Deleted_DT',NULL)->get('mst_labs')->row();
                     $this->load->view('admin/add_lab',$data);
                 }
                 
                 
                 public function save_lab()	
                 {

                		$this->load->library('form_validation');
                		$this->form_validation->set_rules('labname', 'Lab Name', 'required');
                	    $this->form_validation->set_rules('labaddress', 'Lab Address', 'required');
                	    $this->form_validation->set_rules('labtype', 'Lab Type', 'required');

                		if ($this->form_validation->run() == FALSE)
                		{
                		    $this->load->view('admin/add_lab');
                		}
                		else
                		{
                		        $labname = $this->input->post('labname');
                		        $labaddress = $this->input->post('labaddress');
                		        $labtype = $this->input->post('labtype');

                		        $data = array("lab_name"=>$labname,
                		                      "lab_address"=>$labaddress,
                		                      "lab_type"=>$labtype,
                		        "inserted_SI"=>$this->session->userdata('id'),"Inserted_BY"=>$this->session->userdata('username'),"inserted_DT"=>date('Y-m-d H:i:s'));
                    	        $this->db->insert('mst_labs',$data);
                    	      
                    	        $this->session->set_flashdata(array("success"=>1));
    		                    redirect("Admin/lab_grid"); 
                    	        
                		  
                		}   
                 }
              
                 public function update_lab($id)	
                 {
                		$this->load->library('form_validation');
                		$this->form_validation->set_rules('labname', 'Lab Name', 'required');
                	    $this->form_validation->set_rules('labaddress', 'Lab Address', 'required');
                	    $this->form_validation->set_rules('labtype', 'Lab Type', 'required');

                		if ($this->form_validation->run() == FALSE)
                		{
                            $data['getdata'] = $this->db->select('*')->where('lab_id',$id)->where('Deleted_DT',NULL)->get('mst_labs')->row();
                            $this->load->view('admin/add_lab',$data);
                		}
                		else
                		{
                		        $labname = $this->input->post('labname');
                		        $labaddress = $this->input->post('labaddress');
                		        $labtype = $this->input->post('labtype');

                		        $data = array("lab_name"=>$labname,
                		                      "lab_address"=>$labaddress,
                		                      "lab_type"=>$labtype,
                		        "Modify_SI"=>$this->session->userdata('id'),"Modify_BY"=>$this->session->userdata('username'),"Modify_DT"=>date('Y-m-d H:i:s'));
                    	        $this->db->where('lab_id',$id)->update('mst_labs',$data);
                    	      
                    	        $this->session->set_flashdata(array("usuccess"=>1));
    		                    redirect("Admin/lab_grid"); 
                    	        
                		  
                		}   
              }
              
              	public function deletelab($id)
            	{
            			$data=array(
            		            "Deleted_SI"=>$this->session->userdata('id'),
            					"Deleted_BY"=>$this->session->userdata('username'),
            					"Deleted_DT"=>date('Y-m-d H:s:i'));
            		$this->db->where('lab_id',$id)->update('mst_labs',$data);
            		$this->session->set_flashdata(array("dsuccess"=>1));
            		redirect('Admin/lab_grid');
            		
            	}
            	
            	
            	public function editregister($id)
	            {
	                         $data['info'] = $this->db->select('*')->where('case_id',$id)->where('Deleted_DT',NULL)->get('tbl_positive_case_register')->row();     
            		         $data['health'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('tbl_health_center')->result();
                             $data['labs'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('mst_labs')->result();
                             $data['hos_list'] = $this->db->select('*')->where('type',1)->where('Deleted_DT',NULL)->get('mst_hospital')->result();
                             $data['guard_arr'] = $this->db->select('*')->where('patient_status',1)->where('Deleted_DT',NULL)->get('mst_guard')->result();
                             $this->load->view('admin/positive_case_register',$data);
	            }
            	
            	
            	public function new_register_case()
        	    {
            
            		    $this->load->library('form_validation');
            		    $this->form_validation->set_rules('covidportal', 'Goi COVID portal (SSSNO)', 'required');
            		    $this->form_validation->set_rules('distcase', 'District / Corporation Case Number', 'required');
            		    $this->form_validation->set_rules('age', 'Age', 'required');
            		    $this->form_validation->set_rules('gender', 'Gender', 'required');
            		    $this->form_validation->set_rules('address', 'Address', 'required');
            		    $this->form_validation->set_rules('contactno', 'Mobile Number', 'required');
            		    $this->form_validation->set_rules('healthcenter', 'Health Center', 'required');
            		    $this->form_validation->set_rules('prabhagname', 'Prabhag Name', 'required');
            		    $this->form_validation->set_rules('hospitalname', 'Hospital Name', 'required');
            		    $this->form_validation->set_rules('distname', 'District Name', 'required');
            		    $this->form_validation->set_rules('firstadmit', 'Date of 1 Admission', 'required');
            		    $this->form_validation->set_rules('symptoms', 'Symptoms', 'required');
            		    $this->form_validation->set_rules('onsetsym', 'Date Of onset of Symptoms', 'required');
            		    $this->form_validation->set_rules('presentsym', 'Presenting Symptoms', 'required');
            		    $this->form_validation->set_rules('comorbility', 'Co-morbidity condition', 'required');
            		    $this->form_validation->set_rules('clinic', 'Clinical condition the time of admission', 'required');
            		    $this->form_validation->set_rules('protocol', 'Treatment Protocol Used To Patient', 'required');
            		    $this->form_validation->set_rules('secondhos', 'Refered Name of 2 Hospital', 'required');
            		    $this->form_validation->set_rules('seconddate', 'Date of 2 nd Admission', 'required');
            		    $this->form_validation->set_rules('todaycondition', 'Condition Today', 'required');
            		    $this->form_validation->set_rules('outsideindia', 'Travel History Outside india', 'required');
            		    $this->form_validation->set_rules('inindia', 'Travel Within india', 'required');
            		    $this->form_validation->set_rules('positive', 'COVID +ve Family Member', 'required');
            		    $this->form_validation->set_rules('hocovid', 'H/o Contact With COVID +ve Person', 'required');
            		    $this->form_validation->set_rules('gathering', 'Attended Mass Gathering', 'required');
            		    $this->form_validation->set_rules('totalcontat', 'Total Number of Contacts (High risk + Low risk)', 'required');
            		    $this->form_validation->set_rules('contactadmin', 'No. Of Contacts Admitted', 'required');
            		    $this->form_validation->set_rules('contacthome', 'No. Of Contacts At Home', 'required');
            		    $this->form_validation->set_rules('contactsent', 'No. of samples of contacts sent', 'required');
            		    $this->form_validation->set_rules('positivefound', 'No. of contacts found Positive', 'required');
            		    $this->form_validation->set_rules('samplecollect', 'Date of 1st Sample Collection', 'required');
            		    $this->form_validation->set_rules('samplecentre', 'Sample Collection Centre', 'required');
            		    $this->form_validation->set_rules('sampletest', 'Sample Tested At', 'required');
            		    $this->form_validation->set_rules('firstsample', 'Date of result of 1st sample', 'required');
            		    $this->form_validation->set_rules('result', 'Day-14 Test Result', 'required');
            		    $this->form_validation->set_rules('fitestdate', 'Day-15 Test Date', 'required');
            		    $this->form_validation->set_rules('lastresult', 'Day-15 Test Result', 'required');
            		    $this->form_validation->set_rules('outcome', 'Outcome', 'required');
            		    
            		    if ($this->form_validation->run() == FALSE)
            		    {
            		         $data['low_risk'] = $this->db->select('*')->where('risk_type',2)->where('save_staus',1)->where('deleted_DT',NULL)->get('tbl_risk_addmore')->result();
                             $data['high_risk'] = $this->db->select('*')->where('risk_type',1)->where('save_staus',1)->where('deleted_DT',NULL)->get('tbl_risk_addmore')->result();
                             $data['health'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('tbl_health_center')->result();
                             $data['labs'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('mst_labs')->result();
                             $data['hos_list'] = $this->db->select('*')->where('type',1)->where('Deleted_DT',NULL)->get('mst_hospital')->result();
                             $data['guard_arr'] = $this->db->select('*')->where('patient_status',1)->where('Deleted_DT',NULL)->get('mst_guard')->result();
                             $this->load->view('admin/positive_case_register',$data);
            		    }
            		    else
            	    	{
                             $this->Hospital_model->save_case_register();
            		        $this->session->set_flashdata(array("success"=>1));
            		        redirect("Admin/register_grid");       
                 	    }
        	    }
        	    
        	    
        	    
        	    
        	    public function new_register_update($id)
        	    {
            
            		    $this->load->library('form_validation');
            		    $this->form_validation->set_rules('covidportal', 'Goi COVID portal (SSSNO)', 'required');
            		    $this->form_validation->set_rules('distcase', 'District / Corporation Case Number', 'required');
            		    $this->form_validation->set_rules('age', 'Age', 'required');
            		    $this->form_validation->set_rules('gender', 'Gender', 'required');
            		    $this->form_validation->set_rules('address', 'Address', 'required');
            		    $this->form_validation->set_rules('contactno', 'Mobile Number', 'required');
            		    $this->form_validation->set_rules('healthcenter', 'Health Center', 'required');
            		    $this->form_validation->set_rules('prabhagname', 'Prabhag Name', 'required');
            		    $this->form_validation->set_rules('hospitalname', 'Hospital Name', 'required');
            		    $this->form_validation->set_rules('distname', 'District Name', 'required');
            		    $this->form_validation->set_rules('firstadmit', 'Date of 1 Admission', 'required');
            		    $this->form_validation->set_rules('symptoms', 'Symptoms', 'required');
            		    $this->form_validation->set_rules('onsetsym', 'Date Of onset of Symptoms', 'required');
            		    $this->form_validation->set_rules('presentsym', 'Presenting Symptoms', 'required');
            		    $this->form_validation->set_rules('comorbility', 'Co-morbidity condition', 'required');
            		    $this->form_validation->set_rules('clinic', 'Clinical condition the time of admission', 'required');
            		    $this->form_validation->set_rules('protocol', 'Treatment Protocol Used To Patient', 'required');
            		    $this->form_validation->set_rules('secondhos', 'Refered Name of 2 Hospital', 'required');
            		    $this->form_validation->set_rules('seconddate', 'Date of 2 nd Admission', 'required');
            		    $this->form_validation->set_rules('todaycondition', 'Condition Today', 'required');
            		    $this->form_validation->set_rules('outsideindia', 'Travel History Outside india', 'required');
            		    $this->form_validation->set_rules('inindia', 'Travel Within india', 'required');
            		    $this->form_validation->set_rules('positive', 'COVID +ve Family Member', 'required');
            		    $this->form_validation->set_rules('hocovid', 'H/o Contact With COVID +ve Person', 'required');
            		    $this->form_validation->set_rules('gathering', 'Attended Mass Gathering', 'required');
            		    $this->form_validation->set_rules('totalcontat', 'Total Number of Contacts (High risk + Low risk)', 'required');
            		    $this->form_validation->set_rules('contactadmin', 'No. Of Contacts Admitted', 'required');
            		    $this->form_validation->set_rules('contacthome', 'No. Of Contacts At Home', 'required');
            		    $this->form_validation->set_rules('contactsent', 'No. of samples of contacts sent', 'required');
            		    $this->form_validation->set_rules('positivefound', 'No. of contacts found Positive', 'required');
            		    $this->form_validation->set_rules('samplecollect', 'Date of 1st Sample Collection', 'required');
            		    $this->form_validation->set_rules('samplecentre', 'Sample Collection Centre', 'required');
            		    $this->form_validation->set_rules('sampletest', 'Sample Tested At', 'required');
            		    $this->form_validation->set_rules('firstsample', 'Date of result of 1st sample', 'required');
            		    $this->form_validation->set_rules('result', 'Day-14 Test Result', 'required');
            		    $this->form_validation->set_rules('fitestdate', 'Day-15 Test Date', 'required');
            		    $this->form_validation->set_rules('lastresult', 'Day-15 Test Result', 'required');
            		    $this->form_validation->set_rules('outcome', 'Outcome', 'required');
            		    
            		    if ($this->form_validation->run() == FALSE)
            		    {
            		         $data['info'] = $this->db->select('*')->where('case_id',$id)->where('Deleted_DT',NULL)->get('tbl_positive_case_register')->row();     
            		         $data['health'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('tbl_health_center')->result();
                             $data['labs'] = $this->db->select('*')->where('Deleted_DT',NULL)->get('mst_labs')->result();
                             $data['hos_list'] = $this->db->select('*')->where('type',1)->where('Deleted_DT',NULL)->get('mst_hospital')->result();
                             $data['guard_arr'] = $this->db->select('*')->where('patient_status',1)->where('Deleted_DT',NULL)->get('mst_guard')->result();
                             $this->load->view('admin/positive_case_register',$data);
            		    }
            		    else
            	    	{
                             $this->Hospital_model->update_case_register($id);
            		        $this->session->set_flashdata(array("usuccess"=>1));
            		        redirect("Admin/register_grid");       
                 	    }
        	    }
	            
	            public function register_grid()
            	{
                
                	$data['users']=$this->Hospital_model->register_case_grid();
                		//print_r($data);
                	$this->load->view('admin/register_grid',$data);
            	}
            	
            	public function delete_registercase($id)
            	{
            		//$this->db->query("delete from mst_guard where id='".$id."'");
            	//	redirect("Admin/guard");	
            	
            	$data=array(
            		            "deleted_SI"=>$this->session->userdata('id'),
            					"deleted_by"=>$this->session->userdata('name'),
            					"deleted_DT"=>date('Y-m-d H:s:i'));
            		$this->db->where('case_id',$id)->update('tbl_positive_case_register',$data);
            		$this->session->set_flashdata(array("dsuccess"=>1));
            		redirect('Admin/register_grid');
            	}
              
                 
                  
}   
            