<?php 
class Clientapi extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Guard_Model');
       date_default_timezone_set("Asia/Kolkata");
    }
    
    public function total_traveller_patients() {
        
          	 $data['traveller_patients'] = $this->db->select('msg.name, msg.address, msg.contact, msg.age, msg.DOB as "quarantine_date", type, off.Latitude, off.Longitude')
          	                            ->join('tr_assign_duty tad','tad.guard_name = msg.id','left')->join('mst_office off','off.id = tad.office_name','left')->where('((msg.deleted_DT IS NOT NULL AND msg.deactive_cronjob_flag = 1) OR msg.deleted_DT IS NULL)')
          	            
          	            ->where('msg.type', 'Traveler')
          	            ->order_by('msg.id','DESC')->get('mst_guard msg')->result();
//   echo $this->db->last_query();exit;
        echo json_encode($data);exit;
    }
    
    public function total_nontraveller_patients() {
        
          	 $data['traveller_patients'] = $this->db->select('msg.name, msg.address, msg.contact, msg.age, msg.DOB as "quarantine_date", type,off.Latitude, off.Longitude')
          	                            ->join('tr_assign_duty tad','tad.guard_name = msg.id','left')->join('mst_office off','off.id = tad.office_name','left')->where('((msg.deleted_DT IS NOT NULL AND msg.deactive_cronjob_flag = 1) OR msg.deleted_DT IS NULL)')
          	            
          	            ->where('msg.type', 'Non Traveler')
          	            ->order_by('msg.id','DESC')->get('mst_guard msg')->result();

        echo json_encode($data);exit;
    }
    
// ==================================================
    function total_active_quarantime() {
            $data['offices'] = array();
            $offices = $this->db->where('Deleted_DT IS NULL')->get('mst_office')->result();
            if(!empty($offices)) {
                foreach($offices as $office) {
                    $data['offices'][$office->id] = $office; 
                }
            }
            
            $data['assign_quarantine'] = array();
            $assign_q = $this->db->where('Deleted_DT IS NULL')->get('tr_assign_duty')->result();
            if(!empty($assign_q)) {
                foreach($assign_q as $assign) {
                    $data['assign_quarantine'][$assign->guard_name] = !empty($data['offices'][$assign->office_name]) ? $data['offices'][$assign->office_name] : '';  
                }
            }
            
            $data['quarantine_arr'] = array();
            $guards=$this->Guard_Model->fetch_active_patients();
            if(!empty($guards)) {
                foreach($guards as $guard) {
                    if(!empty($data['assign_quarantine'][$guard->id])) {
                        $data['quarantine_arr'][$guard->id]['patient_name'] = $guard->name;
                        $data['quarantine_arr'][$guard->id]['age'] = $guard->age;
                        $data['quarantine_arr'][$guard->id]['contact'] = $guard->contact;
                        $data['quarantine_arr'][$guard->id]['address'] = $guard->address;
                        $data['quarantine_arr'][$guard->id]['quarantine_name'] = !empty($data['assign_quarantine'][$guard->id]) ? $data['assign_quarantine'][$guard->id]->name : '';                        
                        $data['quarantine_arr'][$guard->id]['quarantine_address'] = !empty($data['assign_quarantine'][$guard->id]) ? $data['assign_quarantine'][$guard->id]->contact . ' ' . $data['assign_quarantine'][$guard->id]->city  : '';                        
                        $data['quarantine_arr'][$guard->id]['quarantine_latitude'] = !empty($data['assign_quarantine'][$guard->id]) ? $data['assign_quarantine'][$guard->id]->Latitude : '';                        
                        $data['quarantine_arr'][$guard->id]['quarantine_longitude'] = !empty($data['assign_quarantine'][$guard->id]) ? $data['assign_quarantine'][$guard->id]->Longitude : '';                        
                    }

                    // $data
                }                
            }

        echo json_encode($data['quarantine_arr']);exit;
    }


// ==================================================
    function total_quarantime_complete_athome() {
            $data['offices'] = array();
            $offices = $this->db->where('Deleted_DT IS NULL')->get('mst_office')->result();
            if(!empty($offices)) {
                foreach($offices as $office) {
                    $data['offices'][$office->id] = $office; 
                }
            }
            
            $data['assign_quarantine'] = array();
            $assign_q = $this->db->where('Deleted_DT IS NULL')->get('tr_assign_duty')->result();
            if(!empty($assign_q)) {
                foreach($assign_q as $assign) {
                    $data['assign_quarantine'][$assign->guard_name] = !empty($data['offices'][$assign->office_name]) ? $data['offices'][$assign->office_name] : '';  
                }
            }
            
            $data['quarantine_arr'] = array();
            $guards=$this->Guard_Model->fetch_quarantine_completed_patients();
            if(!empty($guards)) {
                foreach($guards as $guard) {
                    if(!empty($data['assign_quarantine'][$guard->id])) {
                        $data['quarantine_arr'][$guard->id]['patient_name'] = $guard->name;
                        $data['quarantine_arr'][$guard->id]['age'] = $guard->age;
                        $data['quarantine_arr'][$guard->id]['contact'] = $guard->contact;
                        $data['quarantine_arr'][$guard->id]['address'] = $guard->address;
                        $data['quarantine_arr'][$guard->id]['quarantine_name'] = !empty($data['assign_quarantine'][$guard->id]) ? $data['assign_quarantine'][$guard->id]->name : '';                        
                        $data['quarantine_arr'][$guard->id]['quarantine_address'] = !empty($data['assign_quarantine'][$guard->id]) ? $data['assign_quarantine'][$guard->id]->contact . ' ' . $data['assign_quarantine'][$guard->id]->city  : '';                        
                        $data['quarantine_arr'][$guard->id]['quarantine_latitude'] = !empty($data['assign_quarantine'][$guard->id]) ? $data['assign_quarantine'][$guard->id]->Latitude : '';                        
                        $data['quarantine_arr'][$guard->id]['quarantine_longitude'] = !empty($data['assign_quarantine'][$guard->id]) ? $data['assign_quarantine'][$guard->id]->Longitude : '';                        
                    }

                    // $data
                }                
            }

        echo json_encode($data['quarantine_arr']);exit;
    }

            
    // ======================================================
    public function half_hourly_data()
    {
        //  $guardcount = $this->db->where('deleted_DT',NULL)->get('mst_guard')->num_rows();
        //  $mst_quarantine = $this->db->where('deleted_DT',NULL)->get('mst_office')->num_rows();
        //  $emp_count = $this->db->where('Deleted_DT',NULL)->get('login_t')->num_rows();
  
            $userdata = json_decode(file_get_contents('php://input'),true);           
            
            $data['offices'] = array();
            $offices = $this->db->where('Deleted_DT IS NULL')->get('mst_office')->result();
            if(!empty($offices)) {
                foreach($offices as $office) {
                    $data['offices'][$office->id] = $office; 
                }
            }
            
    //         $data['guard'] = array();
    // 	    if(!empty($_POST['guardid']))
    // 		{
    // 	        $data['guardid'] = $_POST['guardid'];
    // 	        $this->db->where("name LIKE '%{$_POST['guardid']}%'");
    // 	    }
            $guards = $this->db->where('Deleted_DT IS NULL')->get('mst_guard')->result();
    
            if(!empty($guards)) {
                foreach($guards as $guard) {
                    $data['guard'][$guard->id]['name'] = $guard->name; 
                    $data['guard'][$guard->id]['contact'] = $guard->contact; 
                }
            }
            
    
    	    if(!empty($userdata['q_date']))
    		{
    	        $data['q_date'] = $userdata['q_date'];
    	        $this->db->where("date(datetime) = '{$userdata['q_date']}'");
    	    } else {
	            $data['q_date'] = date('Y-m-d');
    	        $this->db->where("date(datetime) = '". date('Y-m-d') ."'");   
    	    }
            
            $location_arr = $this->db->where('deleted_DT IS NULL')->order_by('l_id', 'DESC')->get('guard_location')->result();
            $data['location_arr'] = array();
            if(!empty($location_arr)) {
                foreach($location_arr as $location) {
                    if(isset($data['guard'][$location->guard_id])) {
                        $officeLong =  !empty($data['offices'][$location->office_id]->Longitude) ? $data['offices'][$location->office_id]->Longitude : '';
                        $officeLat =  !empty($data['offices'][$location->office_id]->Latitude) ? $data['offices'][$location->office_id]->Latitude : '';
                    
                        
                    $data['location_arr'][$location->l_id]['patient_id'] = $location->guard_id; 
                    $data['location_arr'][$location->l_id]['patient_lat'] = $location->LAT; 
                    $data['location_arr'][$location->l_id]['patient_long'] = $location->LONGI; 
                    $data['location_arr'][$location->l_id]['quarantine_lat'] = $officeLat; 
                    $data['location_arr'][$location->l_id]['quarantine_long'] = $officeLong; 
                    $data['location_arr'][$location->l_id]['time'] = $location->datetime    ; 
                    $data['location_arr'][$location->l_id]['quarantine_name'] = !empty($data['offices'][$location->office_id]->name) ? $data['offices'][$location->office_id]->name : ''; 
                    $data['location_arr'][$location->l_id]['quarantine_city'] = !empty($data['offices'][$location->office_id]->city) ? $data['offices'][$location->office_id]->city : ''; 
                    $data['location_arr'][$location->l_id]['quarantine_address'] = !empty($data['offices'][$location->office_id]->address) ? $data['offices'][$location->office_id]->address : ''; 
                    $data['location_arr'][$location->l_id]['patient_contact'] = !empty($data['guard'][$location->guard_id]['contact']) ? $data['guard'][$location->guard_id]['contact'] : ''; 
                    $data['location_arr'][$location->l_id]['patient_name'] = !empty($data['guard'][$location->guard_id]['name']) ? $data['guard'][$location->guard_id]['name'] : ''; 
                    

                    if(!empty($officeLong) && !empty($officeLat)) {
        // var_dump($this->check_inside_circle($officeLat, $officeLong, $location->LAT, $location->LONGI));exit;
                        $data['location_arr'][$location->l_id]['status'] = $this->check_inside_circle($officeLat, $officeLong, $location->LAT, $location->LONGI);     
                    } else {
                        $data['location_arr'][$location->l_id]['status'] = ''; 
                    }
                    
                    }
                }
            }
             
             $data1 = array( 
                        //   "count_guard"=>$gcount,
                        //   "quorantine_location"=>$g_scount,
                        //   "employee_count"=>$emp_count,
                           "location_arr" => $data['location_arr'],
                         );
            echo json_encode($data1);exit; 
    
    
    }
	  
	  public function check_inside_circle( $center_lat, $center_lng, $lat2, $long2) {

        if($this->checkFloat($center_lat) && $this->checkFloat($center_lng) && $this->checkFloat($lat2) && $this->checkFloat($long2)) {
    	    $distance =  ( 6371 * acos( cos( deg2rad($center_lat) ) * cos( deg2rad( $lat2 ) ) * cos( deg2rad( $long2 ) 
    	                - deg2rad($center_lng) ) + sin( deg2rad($center_lat) ) * sin( deg2rad( $lat2 ) ) ) );
            if(((int)($distance * 1000)) < RADIUS) {
                return 'In Circle';
                // return  $center_lat .'||'. $center_lng .'||'.$lat2 .'||'.$long2 .  '<span style="font-weight: bold; color: green">In Circle</span>' . $distance * 1000;
    			 
            } else {
                return 'Out Circle';
    // 			return    $center_lat .'||'. $center_lng .'||'.$lat2 .'||'.$long2 . '<span style="font-weight: bold; color: red">Out Circle</span>' . $distance * 1000;
            }
        } else {
            return '';
        }

	}
	
	public function checkFloat($num) {
	    // Try to convert the string to a float
        $floatVal = floatval($num);
        // If the parsing succeeded and the value is not equivalent to an int
        if($floatVal && intval($floatVal) != $floatVal)
        {
            return true;
        } else {
            return false;
        }
	}
	
    
    public function patient_status_data() {

        $userdata = json_decode(file_get_contents('php://input'), true);

        $data['offices'] = array();
        $offices = $this->db->where('Deleted_DT IS NULL')->get('mst_office')->result();
        if (!empty($offices)) {
            foreach ($offices as $office) {
                $data['offices'][$office->id] = $office;
            }
        }

        $guards = $this->db->where('Deleted_DT IS NULL')->get('mst_guard')->result();
        if (!empty($guards)) {
            foreach ($guards as $guard) {
                $data['guard'][$guard->id]['name'] = $guard->name;
                $data['guard'][$guard->id]['contact'] = $guard->contact;
                $data['guard'][$guard->id]['age'] = $guard->age;
                $data['guard'][$guard->id]['patient_status'] = $guard->patient_status;
            }
        }
         $location_arr = $this->db->where('deleted_DT IS NULL')->order_by('l_id', 'DESC')->get('guard_location')->result();

        $data['location_arr'] = array();
        if (!empty($location_arr)) {
            foreach ($location_arr as $location) {
                if (isset($data['guard'][$location->guard_id])) {
                    
                    if(empty($data['location_arr'][$location->guard_id]) ||  (!empty($data['location_arr'][$location->guard_id]) && 
                            strtotime($data['location_arr'][$location->guard_id]['time']) <= strtotime($location->datetime))) {
                                
                        $officeLong = !empty($data['offices'][$location->office_id]->Longitude) ? $data['offices'][$location->office_id]->Longitude : '';
                        $officeLat = !empty($data['offices'][$location->office_id]->Latitude) ? $data['offices'][$location->office_id]->Latitude : '';
    
    
                        $data['location_arr'][$location->guard_id]['patient_id'] = $location->guard_id;
                        $data['location_arr'][$location->guard_id]['patient_lat'] = $location->LAT;
                        $data['location_arr'][$location->guard_id]['patient_long'] = $location->LONGI;
                        $data['location_arr'][$location->guard_id]['quarantine_lat'] = $officeLat;
                        $data['location_arr'][$location->guard_id]['quarantine_long'] = $officeLong;
                        $data['location_arr'][$location->guard_id]['time'] = $location->datetime;
                        $data['location_arr'][$location->guard_id]['quarantine_name'] = !empty($data['offices'][$location->office_id]->name) ? $data['offices'][$location->office_id]->name : '';
                        $data['location_arr'][$location->guard_id]['quarantine_city'] = !empty($data['offices'][$location->office_id]->city) ? $data['offices'][$location->office_id]->city : '';
                        $data['location_arr'][$location->guard_id]['quarantine_address'] = !empty($data['offices'][$location->office_id]->address) ? $data['offices'][$location->office_id]->address : '';
                        $data['location_arr'][$location->guard_id]['patient_contact'] = !empty($data['guard'][$location->guard_id]['contact']) ? $data['guard'][$location->guard_id]['contact'] : '';
                        $data['location_arr'][$location->guard_id]['patient_name'] = !empty($data['guard'][$location->guard_id]['name']) ? $data['guard'][$location->guard_id]['name'] : '';
    
    
                        if (!empty($officeLong) && !empty($officeLat)) {
                            // var_dump($this->check_inside_circle($officeLat, $officeLong, $location->LAT, $location->LONGI));exit;
                            $data['location_arr'][$location->guard_id]['status'] = $this->check_inside_circle($officeLat, $officeLong, $location->LAT, $location->LONGI);
                        } else {
                            $data['location_arr'][$location->guard_id]['status'] = '';
                        }
                        
                        $patient_status = $data['guard'][$location->guard_id]['patient_status'];
                        // if(!empty($data['guard'][$location->guard_id]['patient_status'])) {
                        //     $patient_st = $data['guard'][$location->guard_id]['patient_status'];
                        //     if($patient_st == 1) {
                        //         $patient_status = 'Positive';
                        //     } elseif($patient_st == 2) {
                        //         $patient_status = 'B';
                        //     } elseif($patient_st == 3) {
                        //         $patient_status = 'C';
                        //     } elseif($patient_st == 4) {
                        //         $patient_status = 'Death';
                        //     } elseif($patient_st == 5) {
                        //         $patient_status = 'Recover';
                        //     }
                        // }
                        
                        // if(empty($patient_status) && !empty($data['guard'][$location->guard_id]['age'])) {
                        //     $age = $data['guard'][$location->guard_id]['age'];
                        //     if($age < 10 & $age > 60) {
                        //         $patient_status = 'B';
                        //     }
                        //     if($age >= 10 & $age <= 60) {
                        //         $patient_status = 'C';
                        //     }
                        // }
                        $data['location_arr'][$location->guard_id]['patient_status'] = $patient_status;
                    }
                    
                }
            }
        }

        $data1 = array(
            "location_arr" => $data['location_arr'],
        );
        echo json_encode($data1);
        exit;
    }
    
    
    
        public function gethospitalpatient()
    {
        $userdata = json_decode(file_get_contents('php://input'),true);
        
        
        $hospinfo = $this->db->select('*')->where('type',1)->where('Deleted_DT',NULL)->get('mst_hospital')->result();
        
        if(count($hospinfo)>0)
        {
          $i=1;
          foreach($hospinfo as $disp)
          {
              $positivecount = $this->db->select('*')->where('trd.deleted_DT',NULL)->join('mst_guard msg','msg.id=trd.guard_name')->where('msg.patient_status',1)->where('trd.office_name',$disp->hos_id)->where('trd.transfer_status',2)->get('tr_assign_duty trd')->num_rows();
              $recovercount = $this->db->select('*')->where('trd.deleted_DT',NULL)->join('mst_guard msg','msg.id=trd.guard_name')->where('msg.patient_status',5)->where('trd.office_name',$disp->hos_id)->where('trd.transfer_status',2)->get('tr_assign_duty trd')->num_rows();
              
               $patientarray[$i]['positivecount'] = $positivecount;            
               $patientarray[$i]['recovercount'] = $recovercount; 
               $patientarray[$i]['logntitue'] = $disp->Longitude; 
               $patientarray[$i]['latitude'] = $disp->Latitude; 
               $patientarray[$i]['hos_name'] = $disp->hos_name;
               $patientarray[$i]['hospitalid'] = $disp->hos_id;
               $i++;     
          }
           echo $data = json_encode(array( 
                               "record"=>$patientarray,
                             ));
        }    
        else
        {
            echo json_encode(array("failed"=>0)); 
        }
    
    }
    
    
    public function getgovementquorantine()
    {
        $userdata = json_decode(file_get_contents('php://input'),true);
    
        $hospinfo = $this->db->select('*')->where('type',3)->where('Deleted_DT',NULL)->get('mst_hospital')->result();
        
        if(count($hospinfo)>0)
        {
          $i=1;
          foreach($hospinfo as $disp)
          {
              $positivecount = $this->db->select('*')->where('trd.deleted_DT',NULL)->join('mst_guard msg','msg.id=trd.guard_name')->where('msg.patient_status',1)->where('trd.office_name',$disp->hos_id)->where('trd.transfer_status',2)->get('tr_assign_duty trd')->num_rows();
              $recovercount = $this->db->select('*')->where('trd.deleted_DT',NULL)->join('mst_guard msg','msg.id=trd.guard_name')->where('msg.patient_status',5)->where('trd.office_name',$disp->hos_id)->where('trd.transfer_status',2)->get('tr_assign_duty trd')->num_rows();
              
               $patientarray[$i]['positivecount'] = $positivecount;            
               $patientarray[$i]['recovercount'] = $recovercount; 
               $patientarray[$i]['logntitue'] = $disp->Longitude; 
               $patientarray[$i]['latitude'] = $disp->Latitude; 
               $patientarray[$i]['hos_name'] = $disp->hos_name;
               $patientarray[$i]['hospitalid'] = $disp->hos_id;
               $i++;     
          }
           echo $data = json_encode(array( 
                               "record"=>$patientarray,
                             ));
        }    
        else
        {
            echo json_encode(array("failed"=>0)); 
        }
    
    }
    
    
    public function getisolatoinpatient()
    {
        $userdata = json_decode(file_get_contents('php://input'),true);
    
        $hospinfo = $this->db->select('*')->where('type',2)->where('Deleted_DT',NULL)->get('mst_hospital')->result();
        
        if(count($hospinfo)>0)
        {
          $i=1;
          foreach($hospinfo as $disp)
          {
              $positivecount = $this->db->select('*')->where('trd.deleted_DT',NULL)->join('mst_guard msg','msg.id=trd.guard_name')->where('msg.patient_status',1)->where('trd.office_name',$disp->hos_id)->where('trd.transfer_status',2)->get('tr_assign_duty trd')->num_rows();
              $recovercount = $this->db->select('*')->where('trd.deleted_DT',NULL)->join('mst_guard msg','msg.id=trd.guard_name')->where('msg.patient_status',5)->where('trd.office_name',$disp->hos_id)->where('trd.transfer_status',2)->get('tr_assign_duty trd')->num_rows();
              
               $patientarray[$i]['positivecount'] = $positivecount;            
               $patientarray[$i]['recovercount'] = $recovercount; 
               $patientarray[$i]['logntitue'] = $disp->Longitude; 
               $patientarray[$i]['latitude'] = $disp->Latitude; 
               $patientarray[$i]['hos_name'] = $disp->hos_name;
               $patientarray[$i]['hospitalid'] = $disp->hos_id;
               $i++;     
          }
           echo $data = json_encode(array( 
                               "record"=>$patientarray,
                             ));
        }    
        else
        {
            echo json_encode(array("failed"=>0)); 
        }
    
    }
    
    
    public function facility()
   {
       $userdata = json_decode(file_get_contents('php://input'),true);
       
       $data = $this->db->select('intake_capcity as Intakecapcity,ready_beds as ReadyBeds,occupy as Occupancy,ventilators as ventilators,modified_dt as Modified_date')->where('hos_id',$userdata['hosid'])->get('tbl_facilities')->result();
       
       if(count($data)>0)
       {
           echo json_encode(array("result"=>$data)); 
       }
       else
       {
           echo json_encode(array("failed"=>0)); 
       }
       
   }
   
   
   public function patientinhospital()
   {
       $userdata = json_decode(file_get_contents('php://input'),true);
       
       $data = $this->db->select('*')->where('deleted_DT',NULL)->where('transfer_status',2)->get('tr_assign_duty')->num_rows();
       
       if($data > 0)
       {
           echo json_encode(array("hospitalpatients"=>$data)); 
       }
       else
       {
           echo json_encode(array("failed"=>0)); 
       }
   }
   
     public function totalrecovered()
   {
       $userdata = json_decode(file_get_contents('php://input'),true);
       
       $data = $this->db->select('*')->where('deleted_DT',NULL)->where('patient_status',5)->get('mst_guard')->num_rows();
       
       if($data > 0)
       {
           echo json_encode(array("totalrecovred"=>$data)); 
       }
       else
       {
           echo json_encode(array("failed"=>0)); 
       }
       
   }
   
    public function govermentquorantine()
   {
       $userdata = json_decode(file_get_contents('php://input'),true);
       
       $data = $this->db->select('*')->where('deleted_DT',NULL)->where('transfer_status',4)->get('tr_assign_duty')->num_rows();
       
       if($data > 0)
       {
           echo json_encode(array("governmentquorantine"=>$data)); 
       }
       else
       {
           echo json_encode(array("failed"=>0)); 
       }
   }

   public function isolationpatient()
   {
       $userdata = json_decode(file_get_contents('php://input'),true);
       
       $data = $this->db->select('*')->where('deleted_DT',NULL)->where('transfer_status',3)->get('tr_assign_duty')->num_rows();
       
       if($data > 0)
       {
           echo json_encode(array("isolationcount"=>$data)); 
       }
       else
       {
           echo json_encode(array("failed"=>0)); 
       }
   }
        
    
   public function totalpositive()
   {
       $userdata = json_decode(file_get_contents('php://input'),true);
       
       $data = $this->db->select('*')->where('deleted_DT',NULL)->where('patient_status',1)->get('mst_guard')->num_rows();
       
       if($data > 0)
       {
           echo json_encode(array("positivepatient"=>$data)); 
       }
       else
       {
           echo json_encode(array("failed"=>0)); 
       }
   }
   
   public function totaldeath()
   {
       $userdata = json_decode(file_get_contents('php://input'),true);
       
       $data = $this->db->select('*')->where('deleted_DT',NULL)->where('patient_status',4)->get('mst_guard')->num_rows();
       
       if($data > 0)
       {
           echo json_encode(array("deathpatient"=>$data)); 
       }
       else
       {
           echo json_encode(array("failed"=>0)); 
       }
   }
   
   

  public function dashboardapi()
  {
      $death = $this->db->select('*')->where('deleted_DT',NULL)->where('patient_status',4)->get('mst_guard')->num_rows();
      
      $activepatient = $this->db->select('*')->where('deleted_DT',NULL)->where('status','Active')->get('mst_guard')->num_rows();
      
      $isolation = $this->db->select('*')->where('deleted_DT',NULL)->where('transfer_status',3)->get('tr_assign_duty')->num_rows();
      
      $totalcases = $this->db->select('*')->where('deleted_DT',NULL)->where('patient_status',1)->get('mst_guard')->num_rows();
      
      $totalquorantine = $this->db->select('*')->where('msg.deleted_DT',NULL)->join('tr_assign_duty tra','tra.guard_name=msg.id')->get('mst_guard msg')->num_rows();
      
       if($death > 0 || $activepatient>0 || $isolation > 0 || $totalquorantine > 0)
       {
           echo json_encode(array("deathpatient"=>$death,'activepatient'=>$activepatient,'isolationpatient'=>$isolation,'quarantine'=>$totalquorantine)); 
       }
       else
       {
           echo json_encode(array("failed"=>0)); 
       }
  }

}