<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Facility extends CI_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model("Quarantine_Model");
		$this->load->model("Guard_Model");
		$this->load->model("Designation_Model");
		$this->load->model("Duty_Model");
		$this->load->model("Announcement_Model");
		$this->load->model("Complaint_Model");
		$this->load->model("Hospital_model");
		$this->load->model("Admin_m");
		$this->load->library("Custom");
		$this->load->helper(array('form', 'url'));
		
        date_default_timezone_set('Asia/Kolkata');
		if(empty($this->session->userdata("name")))
        {
           redirect("Login");
        }
	}
	
	public function facility_grid()
	{
	    $data['hos_arr']= $this->db->select('tbfac.*,hos.hos_name,hos.type,hos.area_name')->join('mst_hospital hos','hos.hos_id=tbfac.hos_id')->where('Deleted_DT',NULL)->get('tbl_facilities tbfac')->result();
	    $this->load->view('admin/facility_grid',$data);
	}
	
	public function new_facility()
	{
		$data['hos_arr']= $this->db->select('*')->where('Deleted_DT',NULL)->get('mst_hospital')->result();
		$this->load->view('admin/new_facility',$data);
	}
	
	
	public function getfacility()
	{
	    $guard_name = $this->input->post('id');
	    
	    $getinfo = $this->db->select('*')->where('fas_id',$guard_name)->get('tbl_facilities')->result();
	   
  	    echo json_encode(array_shift($getinfo));
	}
	
	
	public function new_facility_insert()	
	{
		$this->load->library('form_validation');
		$this->form_validation->set_rules('hosname', 'Hospital Name', 'required');
		$this->form_validation->set_rules('capacity', 'Capacity ', 'required|numeric');
		$this->form_validation->set_rules('beds', 'Beds', 'required|numeric');
		$this->form_validation->set_rules('occupancy', 'Occupancy ', 'required|numeric');
		$this->form_validation->set_rules('ventilators', 'Ventilators ', 'required|numeric');

		if ($this->form_validation->run() == FALSE)
		{
		    $data['hos_arr']= $this->db->select('*')->where('Deleted_DT',NULL)->get('mst_hospital')->result();
	    	$this->load->view('admin/new_facility',$data);
		}
		else
		{
		    
    	   $data=array("hos_id"=>$_POST['hosname'],
					  "intake_capcity"=>$_POST['capacity'],
					  "ready_beds"=>$_POST['beds'],
					  "occupy"=>$_POST['occupancy'],
					  "ventilators"=>$_POST['ventilators'],
					 "inserted_si"=>$this->session->userdata('id'),
                     "inserted_by"=>$this->session->userdata('name'),
                     "inserted_dt"=>date('Y-m-d H:i:s'));
		    $this->db->insert('tbl_facilities',$data);
		
    		$this->session->set_flashdata(array("success"=>1));
    		redirect("Facility/facility_grid");   
		}
	 }
	 
	 function updatefacility()
	 {
	      
	      $facid = $this->input->post('facid');
          $intake= $this->input->post('intake');
          $beds = $this->input->post('beds');
          $occup= $this->input->post('occup');
          $ven= $this->input->post('ven');
          
          
           $data=array(
					  "intake_capcity"=>$intake,
					  "ready_beds"=>$beds,
					  "occupy"=>$occup,
					  "ventilators"=>$ven,
					  "modified_si"=>$this->session->userdata('id'),
                     "modified_by"=>$this->session->userdata('name'),
                     "modified_dt"=>date('Y-m-d H:i:s'));
		    $this->db->where('fas_id',$facid)->update('tbl_facilities',$data);
		    
          
          $this->session->set_flashdata(array("usuccess"=>1));
    	 
	 }

	
}

?>